/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.gui;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.UtilsString;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.command.ServerItemCommand;
import emanondev.itemedit.gui.PagedGui;
import emanondev.itemedit.storage.ServerStorage;
import emanondev.itemedit.utility.InventoryUtils;
import emanondev.itemedit.utility.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ShowServerItemsGui
implements PagedGui {
    private static final YMLConfig GUI_CONFIG = ItemEdit.get().getConfig();
    private final Inventory inventory;
    private final Player target;
    private final int page;
    private int rows;
    private ArrayList<String> ids;
    private boolean showItems = true;

    public ShowServerItemsGui(Player player, int page) {
        if (player == null) {
            throw new NullPointerException();
        }
        if (page < 1) {
            throw new NullPointerException();
        }
        this.target = player;
        this.rows = GUI_CONFIG.loadInteger("gui.serveritems.rows", 6);
        if (this.rows < 1 || this.rows > 5) {
            this.rows = Math.min(5, Math.max(1, this.rows));
        }
        ServerStorage storage = ItemEdit.get().getServerStorage();
        ArrayList<String> list = new ArrayList<String>(storage.getIds());
        Collections.sort(list);
        int maxPages = list.size() / (this.rows * 9) + (list.size() % (this.rows * 9) == 0 ? 0 : 1);
        if (page > maxPages) {
            page = maxPages;
        }
        this.page = page;
        String title = UtilsString.fix(GUI_CONFIG.loadMessage("gui.serveritems.title", "", false, new String[0]), player, true, "%player_name%", this.target.getName(), "%page%", String.valueOf(page));
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)((this.rows + 1) * 9), (String)title);
        this.updateInventory();
        this.inventory.setItem(this.rows * 9 + 4, this.getPageInfoItem());
        if (page > 1) {
            this.inventory.setItem(this.rows * 9 + 1, this.getPreviousPageItem());
        }
        if (page < maxPages) {
            this.inventory.setItem(this.rows * 9 + 7, this.getNextPageItem());
        }
    }

    public void updateInventory() {
        ServerStorage storage = ItemEdit.get().getServerStorage();
        ArrayList<String> list = new ArrayList<String>(storage.getIds());
        this.ids = list;
        Collections.sort(list);
        for (int i = 0; i < this.rows * 9; ++i) {
            int slot = this.rows * 9 * (this.page - 1) + i;
            if (slot >= list.size()) {
                this.inventory.setItem(i, null);
                continue;
            }
            ItemStack item = storage.getItem(list.get(slot));
            if (item == null) {
                new NullPointerException("invalid id " + list.get(slot)).printStackTrace();
                continue;
            }
            if (this.showItems) {
                this.inventory.setItem(i, item);
                continue;
            }
            ItemStack display = item.clone();
            ItemMeta meta = ItemUtils.getMeta(display);
            meta.addItemFlags(ItemFlag.values());
            meta.setLore(Collections.singletonList(UtilsString.fix("&9Nick: &e" + storage.getNick(list.get(slot)), null, true, new String[0])));
            meta.setDisplayName(UtilsString.fix("&9ID: &e" + list.get(slot), null, true, new String[0]));
            display.setItemMeta(meta);
            this.inventory.setItem(i, display);
        }
    }

    private ItemStack getPageInfoItem() {
        return this.loadLanguageDescription(this.getGuiItem("gui.serveritems.page-info", Material.NAME_TAG), "gui.serveritems.page-info.description", "%player_name%", this.target.getName(), "%page%", String.valueOf(this.page));
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        if (!event.getWhoClicked().equals((Object)this.target)) {
            return;
        }
        if (!this.inventory.equals((Object)event.getClickedInventory())) {
            return;
        }
        if (ItemUtils.isAirOrNull(event.getCurrentItem())) {
            return;
        }
        if (event.getSlot() > this.inventory.getSize() - 9) {
            switch (this.inventory.getSize() - event.getSlot()) {
                case 2: {
                    this.target.openInventory(new ShowServerItemsGui(this.target, this.page + 1).getInventory());
                    return;
                }
                case 5: {
                    this.showItems = !this.showItems;
                    this.updateInventory();
                    return;
                }
            }
            this.target.openInventory(new ShowServerItemsGui(this.target, this.page - 1).getInventory());
            return;
        }
        int slot = this.rows * 9 * (this.page - 1) + event.getSlot();
        String id = this.ids.get(slot);
        ServerStorage storage = ItemEdit.get().getServerStorage();
        ItemStack item = storage.getItem(id);
        if (ItemUtils.isAirOrNull(item)) {
            this.updateInventory();
            return;
        }
        switch (event.getClick()) {
            case LEFT: {
                InventoryUtils.giveAmount((HumanEntity)this.target, item, 1, InventoryUtils.ExcessMode.DELETE_EXCESS);
                return;
            }
            case SHIFT_LEFT: {
                InventoryUtils.giveAmount((HumanEntity)this.target, item, 64, InventoryUtils.ExcessMode.DELETE_EXCESS);
                return;
            }
            case SHIFT_RIGHT: {
                if (!event.getWhoClicked().hasPermission("itemedit.serveritem.delete")) {
                    ServerItemCommand.get().sendPermissionLackMessage("itemedit.serveritem.delete", (CommandSender)event.getWhoClicked());
                    return;
                }
                storage.remove(id);
                this.updateInventory();
                return;
            }
        }
    }

    @Override
    public void onDrag(InventoryDragEvent event) {
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public Player getTargetPlayer() {
        return this.target;
    }

    @Override
    @NotNull
    public ItemEdit getPlugin() {
        return ItemEdit.get();
    }
}

