/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.plugin;

import emanondev.itemedit.APlugin;
import java.io.InputStream;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class PluginAdditionalInfo {
    private final String modrinthProjectId;
    private final String modrinthProjectName;
    private final Integer spigotResourceId;
    private final boolean foliaSupported;
    private final Integer bstatsPluginId;
    private final APlugin plugin;

    public PluginAdditionalInfo(@NotNull APlugin plugin) {
        this.plugin = plugin;
        Yaml yaml = new Yaml();
        Integer spigotResourceId = null;
        String modrinthResourceId = null;
        String modrinthResourceName = null;
        boolean foliaSupported = false;
        Integer bstatsPluginId = null;
        try (InputStream inputStream = plugin.getResource("plugin.yml");){
            if (inputStream == null) {
                throw new IllegalArgumentException("YAML file not found inside JAR");
            }
            Map data = (Map)yaml.load(inputStream);
            spigotResourceId = (Integer)data.get("spigot-resource-id");
            modrinthResourceId = (String)data.get("modrinth-project-id");
            modrinthResourceName = (String)data.get("modrinth-project-name");
            foliaSupported = data.getOrDefault("folia-supported", false);
            bstatsPluginId = (Integer)data.get("bstats-plugin-id");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.spigotResourceId = spigotResourceId;
        this.modrinthProjectId = modrinthResourceId;
        this.modrinthProjectName = modrinthResourceName;
        this.foliaSupported = foliaSupported;
        this.bstatsPluginId = bstatsPluginId;
    }

    public <T> T get(@NotNull String path) {
        return this.get(path, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(@NotNull String path, @Nullable T def) {
        Yaml yaml = new Yaml();
        try (InputStream inputStream = this.plugin.getResource("plugin.yml");){
            if (inputStream == null) {
                throw new IllegalArgumentException("YAML file not found inside JAR");
            }
            Map data = (Map)yaml.load(inputStream);
            T t = data.getOrDefault(path, def);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public String getModrinthProjectId() {
        return this.modrinthProjectId;
    }

    public String getModrinthProjectName() {
        return this.modrinthProjectName;
    }

    public Integer getSpigotResourceId() {
        return this.spigotResourceId;
    }

    public boolean isFoliaSupported() {
        return this.foliaSupported;
    }

    public Integer getBstatsPluginId() {
        return this.bstatsPluginId;
    }

    public APlugin getPlugin() {
        return this.plugin;
    }
}

