/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.storage.mongo;

import com.mongodb.CursorType;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import emanondev.itemedit.storage.ServerStorage;
import emanondev.itemedit.storage.mongo.MongoStorage;
import emanondev.itemedit.utility.ItemUtils;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoServerStorage
implements ServerStorage {
    @NotNull
    private final MongoStorage mongoStorage;

    public MongoServerStorage(@NotNull MongoStorage mongoStorage) {
        this.mongoStorage = mongoStorage;
    }

    @Override
    @Nullable
    public ItemStack getItem(@NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        Document document = (Document)this.mongoStorage.getServerStorage().find(Filters.eq((String)"item_id", (Object)id)).projection(Projections.include((String[])new String[]{"item"})).cursorType(CursorType.NonTailable).first();
        if (document == null) {
            return null;
        }
        Map serializedItem = (Map)document.get((Object)"item", Document.class);
        return this.mapToItem(serializedItem);
    }

    @Nullable
    private ItemStack mapToItem(@Nullable Map<String, Object> serializedItem) {
        if (serializedItem == null) {
            return null;
        }
        ItemStack item = ItemStack.deserialize(serializedItem);
        return item.clone();
    }

    @Override
    @Nullable
    public String getNick(@NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        Document document = (Document)this.mongoStorage.getServerStorage().find(Filters.eq((String)"item_id", (Object)id)).projection(Projections.include((String[])new String[]{"nick", "item"})).cursorType(CursorType.NonTailable).first();
        if (document == null) {
            return null;
        }
        String nick = document.getString((Object)"nick");
        if (nick != null) {
            return nick;
        }
        Map serializedItem = (Map)document.get((Object)"item", Document.class);
        ItemStack item = this.mapToItem(serializedItem);
        if (item == null) {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null || !itemMeta.hasDisplayName()) {
            return item.getType().name().toLowerCase(Locale.ENGLISH);
        }
        return itemMeta.getDisplayName();
    }

    @Override
    public void setItem(@NotNull String id, @NotNull ItemStack item) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        if (ItemUtils.isAirOrNull(item)) {
            throw new IllegalArgumentException();
        }
        item.setAmount(1);
        this.mongoStorage.getServerStorage().insertOne((Object)new Document().append("item_id", (Object)id).append("item", (Object)item.serialize()));
    }

    @Override
    public void setNick(@NotNull String id, @Nullable String nick) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        this.mongoStorage.getServerStorage().updateOne(Filters.eq((String)"item_id", (Object)id), (Bson)(nick != null ? new Document("$set", (Object)new Document("nick", (Object)nick)) : new Document("$unset", (Object)new Document("nick", (Object)""))));
    }

    @Override
    public void remove(@NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        this.mongoStorage.getServerStorage().deleteOne(Filters.eq((String)"item_id", (Object)id));
    }

    @Override
    public void clear() {
        this.mongoStorage.getServerStorage().drop();
    }

    @Override
    @NotNull
    public Set<String> getIds() {
        return (Set)this.mongoStorage.getServerStorage().find().cursorType(CursorType.NonTailable).projection(Projections.include((String[])new String[]{"item_id"})).map(document -> document.getString((Object)"item_id")).into(new HashSet());
    }

    @Override
    public String getId(ItemStack item) {
        if ((item = item.clone()).getAmount() != 1) {
            item.setAmount(1);
        }
        Map serializedItem = item.serialize();
        Document document = (Document)this.mongoStorage.getServerStorage().find(Filters.eq((String)"item", (Object)serializedItem)).cursorType(CursorType.NonTailable).projection(Projections.include((String[])new String[]{"item_id"})).first();
        return document != null ? document.getString((Object)"item_id") : null;
    }

    @Override
    public void reload() {
    }
}

