/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.storage.yaml;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.storage.PlayerStorage;
import emanondev.itemedit.utility.ItemUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class YmlPlayerStorage
implements PlayerStorage {
    private final YMLConfig database = ItemEdit.get().getConfig("database" + File.separatorChar + "player-database.yml");

    private String getBasePath(OfflinePlayer p) {
        return this.storeByUUID() ? p.getUniqueId().toString() : p.getName();
    }

    @Override
    public ItemStack getItem(@NotNull OfflinePlayer player, @NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        ItemStack item = this.database.getItemStack(this.getBasePath(player) + "." + id + ".item", null);
        return item == null ? null : item.clone();
    }

    @Override
    public void setItem(@NotNull OfflinePlayer player, @NotNull String id, @NotNull ItemStack item) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        if (ItemUtils.isAirOrNull(item)) {
            throw new IllegalArgumentException();
        }
        item.setAmount(1);
        this.database.set(this.getBasePath(player) + "." + id + ".item", item);
        this.database.save();
    }

    @Override
    public void remove(@NotNull OfflinePlayer player, @NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        this.database.set(this.getBasePath(player) + "." + id, null);
        this.database.save();
    }

    @Override
    public void clear(@NotNull OfflinePlayer player) {
        this.database.set(this.getBasePath(player), null);
        this.database.save();
    }

    @Override
    @NotNull
    public Set<String> getIds(@NotNull OfflinePlayer player) {
        return this.database.getKeys(this.getBasePath(player));
    }

    @Override
    @NotNull
    public Set<OfflinePlayer> getPlayers() {
        Set playersData = this.database.getKeys(false);
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        boolean uuid = this.storeByUUID();
        for (String val : playersData) {
            if (uuid) {
                players.add(Bukkit.getOfflinePlayer((UUID)UUID.fromString(val)));
                continue;
            }
            players.add(Bukkit.getOfflinePlayer((String)val));
        }
        return players;
    }
}

