/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.utility;

import emanondev.itemedit.aliases.IAliasSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompleteUtility {
    private static final int MAX_COMPLETES = 200;

    private CompleteUtility() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static <T extends Enum<T>> List<String> complete(@NotNull String prefix, @NotNull Class<T> enumClass) {
        prefix = prefix.toUpperCase();
        ArrayList<String> results = new ArrayList<String>();
        int c = 0;
        for (Enum el : (Enum[])enumClass.getEnumConstants()) {
            if (!el.toString().startsWith(prefix)) continue;
            results.add(el.toString().toLowerCase(Locale.ENGLISH));
            if (++c <= 200) continue;
            return results;
        }
        return results;
    }

    @NotNull
    public static <T extends Enum<T>> List<String> complete(@NotNull String prefix, @NotNull Class<T> type, @NotNull Predicate<T> predicate) {
        prefix = prefix.toUpperCase();
        ArrayList<String> results = new ArrayList<String>();
        int c = 0;
        for (Enum el : (Enum[])type.getEnumConstants()) {
            if (!predicate.test(el) || !el.toString().startsWith(prefix)) continue;
            results.add(el.toString().toLowerCase(Locale.ENGLISH));
            if (++c <= 200) continue;
            return results;
        }
        return results;
    }

    @NotNull
    public static List<String> complete(@NotNull String prefix, String ... list) {
        prefix = prefix.toLowerCase(Locale.ENGLISH);
        ArrayList<String> results = new ArrayList<String>();
        int c = 0;
        for (String value : list) {
            if (!value.toLowerCase(Locale.ENGLISH).startsWith(prefix)) continue;
            results.add(value);
            if (++c <= 200) continue;
            return results;
        }
        return results;
    }

    @NotNull
    public static List<String> complete(@NotNull String prefix, @NotNull Collection<String> list) {
        prefix = prefix.toLowerCase(Locale.ENGLISH);
        ArrayList<String> results = new ArrayList<String>();
        int c = 0;
        for (String value : list) {
            if (!value.toLowerCase(Locale.ENGLISH).startsWith(prefix)) continue;
            results.add(value);
            if (++c <= 200) continue;
            return results;
        }
        return results;
    }

    @NotNull
    public static <T> List<String> complete(@NotNull String prefix, @NotNull Iterable<T> list, @NotNull Function<T, String> converter) {
        prefix = prefix.toLowerCase(Locale.ENGLISH);
        ArrayList<String> results = new ArrayList<String>();
        int c = 0;
        for (T value : list) {
            String textValue = converter.apply(value);
            if (textValue == null || !textValue.toLowerCase(Locale.ENGLISH).startsWith(prefix)) continue;
            results.add(textValue);
            if (++c <= 200) continue;
            return results;
        }
        return results;
    }

    @NotNull
    public static List<String> completePlayers(@NotNull String prefix) {
        ArrayList<String> names = new ArrayList<String>();
        String text = prefix.toLowerCase(Locale.ENGLISH);
        Bukkit.getOnlinePlayers().forEach(p -> {
            if (p.getName().toLowerCase(Locale.ENGLISH).startsWith(text)) {
                names.add(p.getName());
            }
        });
        return names;
    }

    @NotNull
    public static List<String> complete(@NotNull String prefix, @Nullable IAliasSet<?> aliases) {
        return CompleteUtility.complete(prefix, aliases, null);
    }

    @NotNull
    public static <T> List<String> complete(@NotNull String prefix, @Nullable IAliasSet<T> aliases, @Nullable Predicate<T> filter) {
        if (aliases == null) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        prefix = prefix.toLowerCase(Locale.ENGLISH);
        int c = 0;
        for (String alias : aliases.getAliases()) {
            if (filter != null && !filter.test(aliases.convertAlias(alias)) || !alias.startsWith(prefix)) continue;
            results.add(alias);
            if (++c <= 200) continue;
            return results;
        }
        return results;
    }
}

