/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.utility;

import emanondev.itemedit.utility.ReflectionUtils;
import org.bukkit.Bukkit;

public final class VersionUtils {
    private static final String[] VERSION_PARTS = VersionUtils.safeSplitVersion();
    public static final int GAME_MAIN_VERSION = Integer.parseInt(VERSION_PARTS[0]);
    public static final int GAME_VERSION = Integer.parseInt(VERSION_PARTS[1]);
    public static final int GAME_SUB_VERSION = VERSION_PARTS.length < 3 ? 0 : Integer.parseInt(VERSION_PARTS[2]);
    private static final boolean HAS_PAPER = ReflectionUtils.isClassPresent("com.destroystokyo.paper.VersionHistoryManager$VersionData");
    private static final boolean HAS_FOLIA = ReflectionUtils.isClassPresent("io.papermc.paper.threadedregions.RegionizedServer");
    private static final boolean HAS_PURPUR = ReflectionUtils.isClassPresent("org.purpurmc.purpur.event.PlayerAFKEvent");

    private VersionUtils() {
        throw new UnsupportedOperationException("VersionUtils is a utility class and cannot be instantiated.");
    }

    public static String getVersionType() {
        return VersionUtils.hasFoliaAPI() ? "Folia" : (VersionUtils.hasPurpurAPI() ? "Purpur" : (VersionUtils.hasPaperAPI() ? "Paper" : "Spigot"));
    }

    public static String getVersionNumber() {
        return GAME_MAIN_VERSION + "." + GAME_VERSION + "." + GAME_SUB_VERSION;
    }

    public static String getVersion() {
        return VersionUtils.getVersionType() + " " + VersionUtils.getVersionNumber();
    }

    private static String[] safeSplitVersion() {
        try {
            return Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid Bukkit version format: " + Bukkit.getBukkitVersion(), e);
        }
    }

    public static boolean isVersionUpTo(int major, int minor) {
        return VersionUtils.isVersionUpTo(major, minor, 99);
    }

    public static boolean isVersionUpTo(int major, int minor, int patch) {
        if (GAME_MAIN_VERSION > major) {
            return false;
        }
        if (GAME_MAIN_VERSION < major) {
            return true;
        }
        if (GAME_VERSION > minor) {
            return false;
        }
        if (GAME_VERSION < minor) {
            return true;
        }
        return GAME_SUB_VERSION <= patch;
    }

    public static boolean isVersionAfter(int major, int minor) {
        return VersionUtils.isVersionAfter(major, minor, 0);
    }

    public static boolean isVersionAfter(int major, int minor, int patch) {
        if (GAME_MAIN_VERSION < major) {
            return false;
        }
        if (GAME_MAIN_VERSION > major) {
            return true;
        }
        if (GAME_VERSION < minor) {
            return false;
        }
        if (GAME_VERSION > minor) {
            return true;
        }
        return GAME_SUB_VERSION >= patch;
    }

    public static boolean isVersionInRange(int majorMin, int minorMin, int majorMax, int minorMax) {
        return VersionUtils.isVersionInRange(majorMin, minorMin, 0, majorMax, minorMax, 99);
    }

    public static boolean isVersionInRange(int majorMin, int minorMin, int patchMin, int majorMax, int minorMax, int patchMax) {
        return VersionUtils.isVersionAfter(majorMin, minorMin, patchMin) && VersionUtils.isVersionUpTo(majorMax, minorMax, patchMax);
    }

    public static boolean hasPaperAPI() {
        return HAS_PAPER;
    }

    public static boolean hasPurpurAPI() {
        return HAS_PURPUR;
    }

    public static boolean hasFoliaAPI() {
        return HAS_FOLIA;
    }
}

