package net.cookedseafood.candywrapper.mixin;

import java.util.Set;
import net.cookedseafood.candywrapper.api.EntityApi;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_243;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1297.class)
public abstract class EntityMixin implements EntityApi{
    @Shadow
    public double lastX;
    @Shadow
    public double lastY;
    @Shadow
    public double lastZ;
    @Shadow
    private class_243 pos;
    @Shadow
    private float yaw;
    @Shadow
    private float pitch;
    @Shadow
    public float lastYaw;
    @Shadow
    public float lastPitch;

    @Redirect(
        method = "startRiding(Lnet/minecraft/entity/Entity;Z)Z",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/EntityType;isSaveable()Z"
        )
    )
    private boolean isSaveableOrPlayer(class_1299<?> entityType) {
        if (entityType.method_5893()) {
            return true;
        }

        return this.isPlayer();
    }

    @Inject(
        method = "addPassenger(Lnet/minecraft/entity/Entity;)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/Entity;emitGameEvent(Lnet/minecraft/registry/entry/RegistryEntry;Lnet/minecraft/entity/Entity;)V",
            shift = At.Shift.AFTER
        )
    )
    private void sendPassengerAdditionPacket(class_1297 passenger, CallbackInfo ci) {
        if (this.isPlayer()) {
            ((class_3222)(Object)this).field_13987.method_14364(new class_2752(((class_1297)(Object)this)));
        }
    }

    @Inject(
        method = "removePassenger(Lnet/minecraft/entity/Entity;)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/Entity;emitGameEvent(Lnet/minecraft/registry/entry/RegistryEntry;Lnet/minecraft/entity/Entity;)V",
            shift = At.Shift.AFTER
        )
    )
    private void sendPassengerRemovePacket(class_1297 passenger, CallbackInfo ci) {
        if (this.isPlayer()) {
            ((class_3222)(Object)this).field_13987.method_14364(new class_2752(((class_1297)(Object)this)));
        }
    }

    @Override
    public double getXDelta() {
        return this.pos.field_1352 - this.lastX;
    }

    @Override
    public double getYDelta() {
        return this.pos.field_1351 - this.lastY;
    }

    @Override
    public double getZDelta() {
        return this.pos.field_1350 - this.lastZ;
    }

    @Override
    public class_243 getPosDelta() {
        return this.pos.method_1023(this.lastX, this.lastY, this.lastZ);
    }

    @Override
    public float getYawDelta() {
        return this.yaw - this.lastYaw;
    }

    @Override
    public float getPitchDelta() {
        return this.pitch - this.lastPitch;
    }

    @Override
    public boolean hasCommandTag(String commandTag) {
        return this.getCommandTags().contains(commandTag);
    }

    @Shadow
    public abstract Set<String> getCommandTags();

    @Shadow
    public abstract boolean isPlayer();
}
