package net.hederamc.cw.mixin;

import java.util.Optional;
import java.util.Set;
import net.hederamc.cw.api.ItemEnchantmentsComponentApi;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_9304.class)
public abstract class ItemEnchantmentsComponentMixin implements ItemEnchantmentsComponentApi {
    @Override
    public int getLevel(String enchantment) {
        Optional<class_6880<class_1887>> matchedEnchantment = this.getEnchantments()
            .stream()
            .filter(presentedEnchantment -> presentedEnchantment.method_55840().equals(enchantment))
            .findAny();
        return matchedEnchantment.isPresent() ? this.getLevel(matchedEnchantment.get()) : 0;
    }

    @Shadow
    public abstract Set<class_6880<class_1887>> getEnchantments();

    @Shadow
    public abstract int getLevel(class_6880<class_1887> enchantment);
}
