package net.hederamc.cw.mixin;

import it.unimi.dsi.fastutil.objects.Object2IntMap.Entry;
import java.util.ArrayList;
import java.util.List;
import net.hederamc.cw.api.LivingEntityApi;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9015;
import net.minecraft.class_9304;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements LivingEntityApi {
    @Shadow
    public boolean dead;
    @Shadow
    public float bodyYaw;
    @Shadow
    public float lastBodyYaw;
    @Shadow
    public float headYaw;
    @Shadow
    public float lastHeadYaw;

    @Override
    public List<Entry<class_6880<class_1887>>> getEnchantments(class_5321<class_1887> key) {
        List<Entry<class_6880<class_1887>>> enchantments = new ArrayList<>();
        this.getEnchantments().stream().filter(entry -> entry.getKey().method_40225(key)).forEach(entry -> enchantments.add(entry));
        return enchantments;
    }

    @Override
    public List<Entry<class_6880<class_1887>>> getEnchantments() {
        List<Entry<class_6880<class_1887>>> enchantments = new ArrayList<>();
        for (class_1304 slot : class_1304.values()) {
            class_1799 stack = this.getEquippedStack(slot);
            if (stack.method_7960()) {
                continue;
            }

            class_9304 component = stack.method_58657();
            if (component.method_57543()) {
                continue;
            }

            component.method_57539().stream().filter(entry -> entry.getKey().comp_349().method_60026(slot)).forEach(entry -> enchantments.add(entry));
        }

        return enchantments;
    }

    @Override
    public void setDead(boolean dead) {
        this.dead = dead;
    }

    @Override
    public float getBodyYawDelta() {
        return this.bodyYaw - this.lastBodyYaw;
    }

    @Override
    public float getHeadYawDelta() {
        return this.headYaw - this.lastHeadYaw;
    }

    @Override
    public class_9015 getScoreHolder() {
        return class_9015.method_55422(((class_1309)(Object)this).method_5845());
    }

    @Shadow
    public abstract class_1799 getEquippedStack(class_1304 slot);
}
