package net.hederamc.cw.mixin;

import net.hederamc.cw.api.ScoreboardApi;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_9022;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_269.class)
public abstract class ScoreboardMixin implements ScoreboardApi {
    @Override
    public class_266 getOrAddObjective(String name, class_274 criterion, class_2561 displayName, class_274.class_275 renderType, boolean displayAutoUpdate, @Nullable class_9022 numberFormat) {
        class_266 objective = this.getNullableObjective(name);
        if (objective == null) {
            objective = this.addObjective(name, criterion, displayName, renderType, displayAutoUpdate, numberFormat);
        }

        return objective;
    }

    @Override
    public class_268 getOrAddTeam(String name) {
        class_268 team = this.getTeam(name);
        if (team == null) {
            team = this.addTeam(name);
        }

        return team;
    }

    @Shadow
    @Nullable
    public abstract class_266 getNullableObjective(@Nullable String name);

    @Shadow
    public abstract class_266 addObjective(String name, class_274 criterion, class_2561 displayName, class_274.class_275 renderType, boolean displayAutoUpdate, @Nullable class_9022 numberFormat);

    @Shadow
    @Nullable
    public abstract class_268 getTeam(String name);

    @Shadow
    public abstract class_268 addTeam(String name);
}
