/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.modcompat;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.modcompat.GlobalPacksCompat;
import com.faboslav.structurify.common.modcompat.ModCompat;
import com.faboslav.structurify.common.modcompat.OpenLoaderCompat;
import com.faboslav.structurify.common.modcompat.TerraCompat;
import com.faboslav.structurify.common.platform.PlatformHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public final class ModChecker {
    public static final List<ModCompat> CUSTOM_RESOURCE_PACK_PROVIDER_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> BIOME_REPLACER_COMPATS = new ArrayList<ModCompat>();

    public static void setupModCompat() {
        try {
            ModChecker.loadModCompat("globalpacks", () -> new GlobalPacksCompat());
            ModChecker.loadModCompat("openloader", () -> new OpenLoaderCompat());
            ModChecker.loadModCompat("terra", () -> new TerraCompat());
            PlatformHooks.PLATFORM_COMPAT.setupPlatformModCompat();
        }
        catch (Throwable e) {
            Structurify.getLogger().error("Failed to setup mod compats");
            e.printStackTrace();
        }
    }

    public static void loadModCompat(String modId, Supplier<ModCompat> loader) {
        try {
            if (PlatformHooks.PLATFORM_HELPER.isModLoaded(modId)) {
                ModCompat compat = loader.get();
                if (compat.compatTypes().contains((Object)ModCompat.Type.CUSTOM_RESOURCE_PACK_PROVIDERS)) {
                    CUSTOM_RESOURCE_PACK_PROVIDER_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.BIOME_REPLACER)) {
                    BIOME_REPLACER_COMPATS.add(compat);
                }
            }
        }
        catch (Throwable e) {
            Structurify.getLogger().error("Failed to load compat with " + modId);
            e.printStackTrace();
        }
    }
}

