/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.controller;

import com.faboslav.structurify.common.config.client.api.controller.element.BiomeStringControllerElement;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;

public final class BiomeStringController
extends AbstractDropdownController<String> {
    private final List<String> allowedValues = WorldgenDataProvider.getBiomes();

    public BiomeStringController(Option<String> option) {
        super(option, WorldgenDataProvider.getBiomes(), false, false);
    }

    public String getString() {
        return (String)this.option.pendingValue();
    }

    public void setFromString(String value) {
        this.option.requestSet((Object)value);
    }

    protected String getValidValue(String value) {
        return this.getValidValue(value, 0);
    }

    protected String getValidValue(String value, int offset) {
        if (value != null && !value.isBlank()) {
            String validBiome;
            String slugifiedValue = value.toLowerCase().replace(" ", "_");
            Stream<String> validBiomes = this.allowedValues.stream().filter(biome -> {
                String slugifiedBiome = biome.toLowerCase().replace(" ", "_");
                String slugifiedTranslatedBiome = LanguageUtil.translateId("biome", biome).getString().toLowerCase().replace(" ", "_");
                return slugifiedBiome.contains(slugifiedValue) || slugifiedTranslatedBiome.contains(slugifiedValue);
            }).sorted((s1, s2) -> {
                if (s1.startsWith(slugifiedValue) && !s2.startsWith(slugifiedValue)) {
                    return -1;
                }
                return !s1.startsWith(slugifiedValue) && s2.startsWith(slugifiedValue) ? 1 : s1.compareTo((String)s2);
            });
            if (offset >= 0 && (validBiome = (String)validBiomes.skip(offset).findFirst().orElse(null)) != null) {
                return validBiome;
            }
        }
        return super.getValidValue(value, offset);
    }

    public Component formatValue() {
        return LanguageUtil.translateId("biome", this.getString()).m_130946_(" (" + this.getString() + ") ");
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new BiomeStringControllerElement(this, screen, widgetDimension);
    }
}

