/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public final class RenderUtil {
    public static void renderBoundingBox(BoundingBox boundingBox, PoseStack poseStack, VertexConsumer vertexConsumer, double cameraX, double cameraY, double cameraZ, float alpha) {
        AABB aabb = new AABB((double)boundingBox.m_162395_(), (double)boundingBox.m_162396_(), (double)boundingBox.m_162398_(), (double)(boundingBox.m_162399_() + 1), (double)(boundingBox.m_162400_() + 1), (double)(boundingBox.m_162401_() + 1)).m_82386_(-cameraX, -cameraY, -cameraZ);
        RenderUtil.renderLineBox(poseStack, vertexConsumer, aabb, 1.0f, 1.0f, 1.0f, alpha);
    }

    public static void renderLineBox(PoseStack poseStack, VertexConsumer buffer, AABB box, float red, float green, float blue, float alpha) {
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)box, (float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void renderLabel(BoundingBox box, String label, Minecraft mc, PoseStack poseStack, MultiBufferSource buffers, double camX, double camY, double camZ) {
        RenderUtil.renderLabel(box, label, mc, poseStack, buffers, camX, camY, camZ, false);
        RenderUtil.renderLabel(box, label, mc, poseStack, buffers, camX, camY, camZ, true);
    }

    private static void renderLabel(BoundingBox box, String label, Minecraft mc, PoseStack poseStack, MultiBufferSource buffers, double camX, double camY, double camZ, boolean inverse) {
        double centerX = (double)(box.m_162395_() + box.m_162399_() + 1) * 0.5;
        double centerZ = (double)(box.m_162398_() + box.m_162401_() + 1) * 0.5;
        double topY = (double)box.m_162400_() + 1.0;
        double labelY = topY + 0.25;
        poseStack.m_85836_();
        poseStack.m_85837_(centerX - camX, labelY - camY, centerZ - camZ);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - (inverse ? 180.0f : 0.0f)));
        float spanX = box.m_71056_();
        float spanZ = box.m_71058_();
        float diagXZ = (float)Math.sqrt(spanX * spanX + spanZ * spanZ);
        float base = 0.03f;
        float dynamic = Math.max(1.0f, diagXZ / 24.0f);
        float scale = Math.max(base, base * dynamic);
        poseStack.m_85841_(-scale, -scale, scale);
        Font font = mc.f_91062_;
        String[] lines = label.split("\n");
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int totalPixelHeight = lines.length * lineHeight;
        float yStart = -totalPixelHeight;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int width = font.m_92895_(line);
            font.m_271703_(line, (float)(-width) / 2.0f, yStart + (float)(i * lineHeight), -1, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        poseStack.m_85849_();
    }
}

