/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class JigsawStructureBiomeCheck {
    public static boolean checkBiomes(StructureData structureData, HeightProvider startHeight, Structure.GenerationContext generationContext) {
        int biomeCheckDistance = (int)Math.ceil((double)structureData.getBiomeCheckDistance() / 16.0);
        if (biomeCheckDistance == 0 || generationContext.biomeSource() instanceof CheckerboardColumnBiomeSource) {
            return true;
        }
        ChunkPos chunkPos = generationContext.chunkPos();
        int y = startHeight.sample((RandomSource)generationContext.random(), new WorldGenerationContext(generationContext.chunkGenerator(), generationContext.heightAccessor()));
        BlockPos blockPos = new BlockPos(generationContext.chunkPos().getMinBlockX(), y, generationContext.chunkPos().getMinBlockZ());
        int sectionY = QuartPos.fromBlock((int)blockPos.getY());
        for (int curChunkX = chunkPos.x - biomeCheckDistance; curChunkX <= chunkPos.x + biomeCheckDistance; ++curChunkX) {
            for (int curChunkZ = chunkPos.z - biomeCheckDistance; curChunkZ <= chunkPos.z + biomeCheckDistance; ++curChunkZ) {
                Holder biome = generationContext.biomeSource().getNoiseBiome(QuartPos.fromSection((int)curChunkX), sectionY, QuartPos.fromSection((int)curChunkZ), generationContext.randomState().sampler());
                if (generationContext.validBiome().test(biome)) continue;
                return false;
            }
        }
        return true;
    }
}

