/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class JigsawStructureFlatnessCheck {
    public static boolean checkFlatness(StructureData structureData, HeightProvider startHeight, Structure.GenerationContext generationContext) {
        int flatnessCheckDistance = structureData.getFlatnessCheckDistance();
        int offsetStep = (int)Math.ceil((float)flatnessCheckDistance / 2.0f);
        int stepAmount = (int)Math.pow((double)(2 * flatnessCheckDistance) / (double)offsetStep + 1.0, 2.0);
        int allowedAirBlockSteps = stepAmount / 2;
        int allowedLiquidBlockSteps = stepAmount / 2;
        int flatnessCheckThreshold = structureData.getFlatnessCheckThreshold();
        boolean areAirBlocksAllowed = structureData.areAirBlocksAllowedInFlatnessCheck();
        boolean areLiquidBlocksAllowed = structureData.areLiquidBlocksAllowedInFlatnessCheck();
        if (flatnessCheckDistance == 0 || flatnessCheckThreshold == 0) {
            return true;
        }
        ChunkPos chunkPos = generationContext.chunkPos();
        int y = startHeight.sample((RandomSource)generationContext.random(), new WorldGenerationContext(generationContext.chunkGenerator(), generationContext.heightAccessor()));
        BlockPos blockPos = new BlockPos(chunkPos.getMinBlockX(), y, chunkPos.getMinBlockZ());
        int baseX = blockPos.getX();
        int baseZ = blockPos.getZ();
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        int airBlockSteps = 0;
        int fluidBlockSteps = 0;
        for (int xOffset = -flatnessCheckDistance; xOffset <= flatnessCheckDistance; xOffset += offsetStep) {
            for (int zOffset = -flatnessCheckDistance; zOffset <= flatnessCheckDistance; zOffset += offsetStep) {
                int x = xOffset + baseX;
                int z = zOffset + baseZ;
                int height = generationContext.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, generationContext.heightAccessor(), generationContext.randomState());
                minHeight = Math.min(minHeight, height);
                if ((maxHeight = Math.max(maxHeight, height)) - minHeight > flatnessCheckThreshold) {
                    return false;
                }
                if (areAirBlocksAllowed && areLiquidBlocksAllowed) continue;
                NoiseColumn blockView = generationContext.chunkGenerator().getBaseColumn(x, z, generationContext.heightAccessor(), generationContext.randomState());
                BlockState blockState = blockView.getBlock(height);
                if (!areAirBlocksAllowed && blockState.isAir() && ++airBlockSteps >= allowedAirBlockSteps) {
                    return false;
                }
                if (areLiquidBlocksAllowed || blockState.getFluidState().isEmpty() || ++fluidBlockSteps < allowedLiquidBlockSteps) continue;
                return false;
            }
        }
        return true;
    }
}

