/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.client.api.controller.builder.BiomeStringControllerBuilder;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class StructureConfigScreen {
    public static YACLScreen create(Screen parent, String structureId) {
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((Component)Component.literal((String)structureId)).save(Structurify.getConfig()::save);
        MutableComponent translatedStructureName = LanguageUtil.translateId("structure", structureId);
        ConfigCategory.Builder structureCategoryBuilder = ConfigCategory.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.title", (Object[])new Object[]{translatedStructureName})).tooltip(new Component[]{Component.translatable((String)"gui.structurify.structures.structure.description")});
        structureCategoryBuilder.option((Option)LabelOption.create((Component)Component.translatable((String)"gui.structurify.structures.flatness_check_group.title")));
        Option enableFlatnessCheckOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.enable_flatness_check.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.enable_flatness_check.description")})).binding((Object)false, () -> Structurify.getConfig().getStructureData().get(structureId).isFlatnessCheckEnabled(), enableFlatnessCheck -> Structurify.getConfig().getStructureData().get(structureId).setEnableFlatnessCheck((boolean)enableFlatnessCheck)).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.translatable((String)"gui.structurify.label.yes") : Component.translatable((String)"gui.structurify.label.no"))).coloured(true)).build();
        structureCategoryBuilder.option(enableFlatnessCheckOption);
        Option flatnessCheckDistanceOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.flatness_check_distance.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.flatness_check_distance.description")})).binding((Object)Structurify.getConfig().getStructureData().get(structureId).getDefaultCheckDistance(), () -> Structurify.getConfig().getStructureData().get(structureId).getFlatnessCheckDistance(), flatnessCheckDistance -> Structurify.getConfig().getStructureData().get(structureId).setFlatnessCheckDistance((int)flatnessCheckDistance)).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)256)).step((Number)1)).build();
        structureCategoryBuilder.option(flatnessCheckDistanceOption);
        Option flatnessCheckThresholdOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.flatness_check_threshold.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.flatness_check_threshold.description")})).binding((Object)10, () -> Structurify.getConfig().getStructureData().get(structureId).getFlatnessCheckThreshold(), flatnessCheckThreshold -> Structurify.getConfig().getStructureData().get(structureId).setFlatnessCheckThreshold((int)flatnessCheckThreshold)).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)256)).step((Number)1)).build();
        structureCategoryBuilder.option(flatnessCheckThresholdOption);
        Option allowAirBlocksInFlatnessCheckOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.allow_air_blocks_in_flatness_check.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.allow_air_blocks_in_flatness_check.description")})).binding((Object)false, () -> Structurify.getConfig().getStructureData().get(structureId).areAirBlocksAllowedInFlatnessCheck(), allowAirBlocksInFlatnessCheck -> Structurify.getConfig().getStructureData().get(structureId).setAllowAirBlocksInFlatnessCheck((boolean)allowAirBlocksInFlatnessCheck)).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.translatable((String)"gui.structurify.label.yes") : Component.translatable((String)"gui.structurify.label.no"))).coloured(true)).build();
        structureCategoryBuilder.option(allowAirBlocksInFlatnessCheckOption);
        Option allowLiquidBlocksInFlatnessCheckOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.allow_liquid_blocks_in_flatness_check.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.allow_liquid_blocks_in_flatness_check.description")})).binding((Object)false, () -> Structurify.getConfig().getStructureData().get(structureId).areLiquidBlocksAllowedInFlatnessCheck(), allowLiquidBlocksInFlatnessCheck -> Structurify.getConfig().getStructureData().get(structureId).setAllowLiquidBlocksInFlatnessCheck((boolean)allowLiquidBlocksInFlatnessCheck)).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.translatable((String)"gui.structurify.label.yes") : Component.translatable((String)"gui.structurify.label.no"))).coloured(true)).build();
        structureCategoryBuilder.option(allowLiquidBlocksInFlatnessCheckOption);
        structureCategoryBuilder.option((Option)LabelOption.create((Component)Component.translatable((String)"gui.structurify.structures.biome_check_group.title")));
        Option enableBiomeCheckOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.enable_biome_check.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.enable_biome_check.description")})).binding((Object)false, () -> Structurify.getConfig().getStructureData().get(structureId).isBiomeCheckEnabled(), enableBiomeCheck -> Structurify.getConfig().getStructureData().get(structureId).setEnableBiomeCheck((boolean)enableBiomeCheck)).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.translatable((String)"gui.structurify.label.yes") : Component.translatable((String)"gui.structurify.label.no"))).coloured(true)).build();
        structureCategoryBuilder.option(enableBiomeCheckOption);
        Option biomeCheckDistanceOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.biome_check_distance.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.biome_check_distance.description")})).binding((Object)Structurify.getConfig().getStructureData().get(structureId).getDefaultCheckDistance(), () -> Structurify.getConfig().getStructureData().get(structureId).getBiomeCheckDistance(), biomeCheckDistance -> Structurify.getConfig().getStructureData().get(structureId).setBiomeCheckDistance((int)biomeCheckDistance)).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)256)).step((Number)1)).build();
        structureCategoryBuilder.option(biomeCheckDistanceOption);
        ListOption biomesOption = ListOption.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.biomes.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.biomes.description", (Object[])new Object[]{translatedStructureName})})).insertEntriesAtEnd(false).binding(Structurify.getConfig().getStructureData().get(structureId).getDefaultBiomes(), () -> Structurify.getConfig().getStructureData().get(structureId).getBiomes(), biomes -> Structurify.getConfig().getStructureData().get(structureId).setBiomes((List<String>)biomes)).controller(BiomeStringControllerBuilder::create).initial((Object)"").build();
        structureCategoryBuilder.group((OptionGroup)biomesOption);
        yacl.category(structureCategoryBuilder.build());
        return (YACLScreen)yacl.build().generateScreen(parent);
    }
}

