/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.data;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyRandomSpreadStructurePlacement;
import com.faboslav.structurify.common.api.StructurifyStructurePlacement;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.mixin.structure.jigsaw.MaxDistanceFromCenterAccessor;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public final class WorldgenDataProvider {
    private static List<String> biomes = new ArrayList<String>();
    private static Map<String, StructureData> structureData = new TreeMap<String, StructureData>();
    private static Map<String, StructureSetData> structureSetData = new TreeMap<String, StructureSetData>();
    private static final Comparator<String> alphabeticallComparator = (key1, key2) -> {
        boolean isKey1Minecraft = key1.startsWith("minecraft:");
        boolean isKey2Minecraft = key2.startsWith("minecraft:");
        if (isKey1Minecraft && !isKey2Minecraft) {
            return -1;
        }
        if (!isKey1Minecraft && isKey2Minecraft) {
            return 1;
        }
        return key1.compareTo((String)key2);
    };

    public static List<String> getBiomes() {
        return biomes;
    }

    public static Map<String, StructureData> getStructures() {
        return structureData;
    }

    public static Map<String, StructureSetData> getStructureSets() {
        return structureSetData;
    }

    public static void loadWorldgenData() {
        biomes = WorldgenDataProvider.loadBiomes();
        structureData = WorldgenDataProvider.loadStructures();
        structureSetData = WorldgenDataProvider.loadStructureSets();
    }

    public static List<String> loadBiomes() {
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return Collections.emptyList();
        }
        ArrayList<String> biomes = new ArrayList<String>();
        for (HolderSet.Named biomeTag : biomeRegistry.listTags().toList()) {
            biomes.add("#" + ((TagKey)biomeTag.unwrapKey().get()).location().toString());
        }
        for (Holder.Reference biome : biomeRegistry.listElements().toList()) {
            biomes.add(((ResourceKey)biome.unwrapKey().get()).location().toString());
        }
        return biomes;
    }

    public static Map<String, StructureData> loadStructures() {
        HolderLookup.Provider registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        HolderLookup.RegistryLookup structureRegistry = registryManager.lookupOrThrow(Registries.STRUCTURE);
        HolderLookup.RegistryLookup biomeRegistry = registryManager.lookupOrThrow(Registries.BIOME);
        TreeMap<String, StructureData> structures = new TreeMap<String, StructureData>(alphabeticallComparator);
        for (Holder.Reference structureReference : structureRegistry.listElements().toList()) {
            Structure structure = (Structure)structureReference.value();
            String structureId = structureReference.key().location().toString();
            Either biomeStorage = structure.biomes().unwrap();
            ArrayList<String> defaultBiomes = new ArrayList<String>();
            biomeStorage.mapLeft(biomeTagKey -> {
                biomeRegistry.get(biomeTagKey).ifPresent(biomes -> {
                    for (Holder biome : biomes) {
                        String biomeKey = ((ResourceKey)biome.unwrapKey().get()).location().toString();
                        if (defaultBiomes.contains(biomeKey)) continue;
                        defaultBiomes.add(biomeKey);
                    }
                });
                return null;
            });
            biomeStorage.mapRight(biomes -> {
                for (Holder biome : biomes) {
                    String biomeKey = ((ResourceKey)biome.unwrapKey().get()).location().toString();
                    if (defaultBiomes.contains(biomeKey)) continue;
                    defaultBiomes.add(biomeKey);
                }
                return null;
            });
            int checkRadius = WorldgenDataProvider.getCheckRadiusForStructure(structure);
            structures.put(structureId, new StructureData(defaultBiomes, checkRadius));
        }
        return structures;
    }

    public static Map<String, StructureSetData> loadStructureSets() {
        HolderLookup.Provider registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        HolderLookup.RegistryLookup structureSetRegistry = registryManager.lookupOrThrow(Registries.STRUCTURE_SET);
        TreeMap<String, StructureSetData> structureSets = new TreeMap<String, StructureSetData>();
        for (Holder.Reference structureSetReference : structureSetRegistry.listElements().toList()) {
            StructureSet structureSet = (StructureSet)structureSetReference.value();
            ResourceLocation structureSetId = structureSetReference.key().location();
            String structureSetStringId = structureSetId.toString();
            StructurePlacement structureSetPlacement = structureSet.placement();
            int salt = 0;
            float frequency = 0.0f;
            int spacing = 0;
            int separation = 0;
            if (structureSetPlacement instanceof StructurifyStructurePlacement) {
                StructurifyStructurePlacement structurePlacement = (StructurifyStructurePlacement)structureSetPlacement;
                salt = structurePlacement.structurify$getOriginalSalt();
                frequency = structurePlacement.structurify$getOriginalFrequency();
            }
            if (structureSetPlacement instanceof StructurifyRandomSpreadStructurePlacement) {
                StructurifyRandomSpreadStructurePlacement randomSpreadStructurePlacement = (StructurifyRandomSpreadStructurePlacement)structureSetPlacement;
                spacing = randomSpreadStructurePlacement.structurify$getOriginalSpacing();
                separation = randomSpreadStructurePlacement.structurify$getOriginalSeparation();
            }
            if (!(structureSet.placement() instanceof StructurePlacement)) continue;
            structureSets.put(structureSetStringId, new StructureSetData(salt, frequency, spacing, separation));
        }
        return structureSets;
    }

    private static int getCheckRadiusForStructure(Structure structure) {
        Field[] fields;
        if (structure instanceof JigsawStructure) {
            return ((MaxDistanceFromCenterAccessor)structure).structurify$getMaxDistanceFromCenter();
        }
        Class<?> clazz = structure.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals("maxDistanceFromCenter")) continue;
            field.setAccessible(true);
            try {
                if (Optional.class.isAssignableFrom(field.getType())) {
                    Optional optionalValue = (Optional)field.get(structure);
                    return optionalValue.map(val -> (Integer)val).orElse(0);
                }
                return field.getInt(structure);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Structurify.getLogger().error(e.getMessage());
                break;
            }
        }
        return 0;
    }
}

