/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.mixin.structure;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.modcompat.ModChecker;
import com.faboslav.structurify.common.modcompat.ModCompat;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Structure.class})
public abstract class StructureMixin
implements StructurifyStructure {
    @Unique
    @Nullable
    public ResourceLocation structurify$structureIdentifier = null;
    @Unique
    @Nullable
    public HolderSet<Biome> structurify$structureBiomes = null;

    @Override
    public void structurify$setStructureIdentifier(ResourceLocation structureSetIdentifier) {
        this.structurify$structureIdentifier = structureSetIdentifier;
    }

    @Override
    @Nullable
    public ResourceLocation structurify$getStructureIdentifier() {
        return this.structurify$structureIdentifier;
    }

    @Override
    public void structurify$setStructureBiomes(@Nullable HolderSet<Biome> biomeHolderSet) {
        this.structurify$structureBiomes = biomeHolderSet;
    }

    @Override
    @Nullable
    public HolderSet<Biome> structurify$getStructureBiomes() {
        return this.structurify$structureBiomes;
    }

    @WrapMethod(method={"biomes"})
    private HolderSet<Biome> structurify$biomes(Operation<HolderSet<Biome>> original) {
        if (this.structurify$getStructureBiomes() == null) {
            HolderSet<Biome> biomeHolderSet = this.structurify$getBiomeHolderSet(original);
            this.structurify$setStructureBiomes(biomeHolderSet);
        }
        return this.structurify$getStructureBiomes();
    }

    @Unique
    private HolderSet<Biome> structurify$getBiomeHolderSet(Operation<HolderSet<Biome>> original) {
        ResourceLocation structureId = this.structurify$getStructureIdentifier();
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return (HolderSet)original.call(new Object[0]);
        }
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return (HolderSet)original.call(new Object[0]);
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        List<String> biomeIds = structureData.getBiomes();
        for (ModCompat modCompat : ModChecker.BIOME_REPLACER_COMPATS) {
            biomeIds = modCompat.getReplacedBiomes(biomeIds);
        }
        ArrayList<Object> biomeHolders = new ArrayList<Object>();
        for (String biomeId : biomeIds) {
            if (biomeId.contains("#")) {
                TagKey biomeTagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Structurify.makeNamespacedId(biomeId.replace("#", "")));
                HolderSet.Named biomeTagHolder = biomeRegistry.get(biomeTagKey).orElse(null);
                if (biomeTagHolder == null) continue;
                for (Holder biomeHolder : biomeTagHolder.stream().toList()) {
                    biomeHolders.add(biomeHolder);
                }
                continue;
            }
            ResourceKey biomeResourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Structurify.makeNamespacedId(biomeId.replace("#", "")));
            Holder.Reference biomeHolder = biomeRegistry.get(biomeResourceKey).orElse(null);
            if (biomeHolder == null) continue;
            biomeHolders.add(biomeHolder);
        }
        return HolderSet.direct(biomeHolders);
    }
}

