/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.commands;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.DebugData;
import com.faboslav.structurify.common.mixin.LocateCommandInvoker;
import com.faboslav.structurify.world.level.structure.checks.StructureChecker;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public final class StructurifyCommand {
    private static final SuggestionProvider<CommandSourceStack> DEBUG_MODE_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82981_(DebugData.DebugMode.getNames(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SAMPLING_MODE_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82981_(DebugData.SamplingMode.getNames(), (SuggestionsBuilder)builder);

    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"structurify").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"dump").executes(ctx -> {
            Structurify.getConfig().dump();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Structurify config dumped to \"" + String.valueOf(Structurify.getConfig().configDumpPath) + "\".")), !((CommandSourceStack)ctx.getSource()).m_230897_());
            return 1;
        }))).then(Commands.m_82127_((String)"locate").then(Commands.m_82127_((String)"structure").then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256944_)).executes(commandContext -> StructurifyCommand.locateStructure((CommandSourceStack)commandContext.getSource(), (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.m_246379_((CommandContext)commandContext, (String)"structure", (ResourceKey)Registries.f_256944_, (DynamicCommandExceptionType)LocateCommandInvoker.structurify$getStructureInvalidError()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"enable").requires(src -> src.m_6761_(2))).executes(ctx -> {
            Structurify.getConfig().getDebugData().setEnabled(true);
            Structurify.getConfig().getDebugData().setDebugMode(DebugData.DebugMode.FLATNESS);
            Structurify.getConfig().getDebugData().setSamplingMode(DebugData.SamplingMode.FINAL);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Structurify debug enabled."), !((CommandSourceStack)ctx.getSource()).m_230897_());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"disable").requires(src -> src.m_6761_(2))).executes(ctx -> {
            Structurify.getConfig().getDebugData().setEnabled(false);
            Structurify.getConfig().getDebugData().setDebugMode(DebugData.DebugMode.NONE);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Structurify debug disabled."), !((CommandSourceStack)ctx.getSource()).m_230897_());
            return 1;
        }))).then(Commands.m_82127_((String)"debug_mode").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"debugMode", (ArgumentType)StringArgumentType.word()).suggests(DEBUG_MODE_SUGGESTIONS).requires(src -> src.m_6761_(2))).executes(ctx -> {
            DebugData.DebugMode debugMode;
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"debugMode");
            try {
                debugMode = DebugData.DebugMode.valueOf(raw.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown debug mode: " + raw)));
                return 0;
            }
            Structurify.getConfig().getDebugData().setEnabled(true);
            Structurify.getConfig().getDebugData().setDebugMode(debugMode);
            StructurifyCommand.reloadStructureChecks((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Structurify debug mode changed to " + String.valueOf((Object)debugMode) + ".")), !((CommandSourceStack)ctx.getSource()).m_230897_());
            return 1;
        })))).then(Commands.m_82127_((String)"sampling_mode").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"samplingMode", (ArgumentType)StringArgumentType.word()).suggests(SAMPLING_MODE_SUGGESTIONS).requires(src -> src.m_6761_(2))).executes(ctx -> {
            DebugData.SamplingMode samplingMode;
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"samplingMode");
            try {
                samplingMode = DebugData.SamplingMode.valueOf(raw.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown sampling mode: " + raw)));
                return 0;
            }
            Structurify.getConfig().getDebugData().setSamplingMode(samplingMode);
            Structurify.getConfig().getDebugData().clearStructureFlatnessCheckOverviews();
            Structurify.getConfig().getDebugData().clearStructureFlatnessCheckSamples();
            Structurify.getConfig().getDebugData().clearStructureBiomeCheckOverviews();
            Structurify.getConfig().getDebugData().clearStructureBiomeCheckSamples();
            StructurifyCommand.reloadStructureChecks((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Structurify debug sampling mode changed to " + String.valueOf((Object)samplingMode) + ".")), !((CommandSourceStack)ctx.getSource()).m_230897_());
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"structures").requires(src -> src.m_6761_(2))).executes(ctx -> StructurifyCommand.getStructures((CommandSourceStack)ctx.getSource())))));
    }

    private static void reloadStructureChecks(CommandContext<CommandSourceStack> ctx) {
        ServerLevel serverLevel = ((CommandSourceStack)ctx.getSource()).m_81372_();
        BlockPos blockPos = BlockPos.m_274446_((Position)((CommandSourceStack)ctx.getSource()).m_81371_());
        ChunkPos center = new ChunkPos(blockPos);
        ServerChunkCache chunkSource = serverLevel.m_7726_();
        ChunkGenerator chunkGenerator = chunkSource.m_8481_();
        BiomeSource biomeSource = chunkGenerator.m_62218_();
        RandomState randomState = chunkSource.m_214994_();
        int viewDistance = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11312_();
        int chunkRadius = Math.max(1, (int)((double)viewDistance * 1.33));
        for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
            for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
                ChunkPos chunkPos = new ChunkPos(center.f_45578_ + dx, center.f_45579_ + dz);
                LevelChunk chunk = chunkSource.m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
                if (chunk == null) continue;
                for (Map.Entry structureStartEntry : chunk.m_6633_().entrySet()) {
                    StructureChecker.debugCheckStructure((StructureStart)structureStartEntry.getValue(), (StructurifyStructure)structureStartEntry.getKey(), chunkGenerator, (LevelHeightAccessor)serverLevel, randomState, biomeSource);
                }
            }
        }
    }

    private static int getStructures(CommandSourceStack source) {
        ServerLevel level = source.m_81372_();
        BlockPos pos = BlockPos.m_274446_((Position)source.m_81371_());
        return 0;
    }

    private static int locateStructure(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> structure) throws CommandSyntaxException {
        ServerLevel serverLevel = source.m_81372_();
        BlockPos blockPos = BlockPos.m_274446_((Position)source.m_81371_());
        Registry registry = source.m_81372_().m_9598_().m_175515_(Registries.f_256944_);
        HolderSet holderSet = (HolderSet)LocateCommandInvoker.structurify$invokeGetHolders(structure, (Registry<Structure>)registry).orElseThrow(() -> LocateCommandInvoker.structurify$getStructureInvalidError().create((Object)structure.m_245390_()));
        source.m_288197_(() -> Component.m_237113_((String)("Locating " + structure.m_245390_() + " in the radius of 6400 chunks")), false);
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.f_211544_);
        CompletableFuture.supplyAsync(() -> serverLevel.m_7726_().m_8481_().m_223037_(serverLevel, holderSet, blockPos, 6400, false), Util.m_183991_()).thenAcceptAsync(pair -> {
            stopwatch.stop();
            source.m_81377_().execute(() -> {
                if (pair == null) {
                    source.m_81352_((Component)Component.m_237115_((String)LocateCommandInvoker.structurify$getStructureNotFoundError().create((Object)structure.m_245390_()).getLocalizedMessage()));
                } else {
                    LocateCommand.m_262810_((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)structure, (BlockPos)blockPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
                }
            });
        }, (Executor)Util.m_183991_());
        return 0;
    }
}

