/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.world.level.structure.StructureSectionClaim;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public final class StructureOverlapCheck {
    public static final int CELL_X = 8;
    public static final int CELL_Y = 8;
    public static final int CELL_Z = 8;

    public static boolean checkForOverlap(StructureCheckData structureCheckData, StructurifyChunkGenerator structurifyChunkGenerator) {
        StructureStart start = structureCheckData.getStructureStart();
        long[] structureCells = StructureOverlapCheck.getStructurePiecesSections(start);
        long structureCenter = start.m_73601_().m_162394_().m_121878_();
        boolean overlapCheckResult = !StructureOverlapCheck.claimStructureSections(structurifyChunkGenerator, structureCells, structureCheckData.getStructureId(), structureCenter);
        return overlapCheckResult;
    }

    private static long[] getStructurePiecesSections(StructureStart start) {
        HashSet<Long> unique = new HashSet<Long>();
        for (StructurePiece piece : start.m_73602_()) {
            BoundingBox box = piece.m_73547_();
            int minCx = Math.floorDiv(box.m_162395_(), 8);
            int maxCx = Math.floorDiv(box.m_162399_(), 8);
            int minCy = Math.floorDiv(box.m_162396_(), 8);
            int maxCy = Math.floorDiv(box.m_162400_(), 8);
            int minCz = Math.floorDiv(box.m_162398_(), 8);
            int maxCz = Math.floorDiv(box.m_162401_(), 8);
            for (int cz = minCz; cz <= maxCz; ++cz) {
                for (int cx = minCx; cx <= maxCx; ++cx) {
                    for (int cy = minCy; cy <= maxCy; ++cy) {
                        unique.add(StructureOverlapCheck.packCell(cx, cy, cz));
                    }
                }
            }
        }
        long[] keys = new long[unique.size()];
        int i = 0;
        for (Long k : unique) {
            keys[i++] = k;
        }
        return keys;
    }

    private static long packCell(int x, int y, int z) {
        return (long)(x & 0x1FFFFF) << 42 | (long)(y & 0x1FFFFF) << 21 | (long)(z & 0x1FFFFF);
    }

    public static BlockPos unpackCell(long packedKey, int cellX, int cellY, int cellZ) {
        int x = (int)(packedKey >> 42);
        int y = (int)(packedKey >> 21 & 0x1FFFFFL);
        int z = (int)(packedKey & 0x1FFFFFL);
        if (x >= 0x100000) {
            x -= 0x200000;
        }
        if (y >= 0x100000) {
            y -= 0x200000;
        }
        if (z >= 0x100000) {
            z -= 0x200000;
        }
        return new BlockPos(x * cellX, y * cellY, z * cellZ);
    }

    private static boolean claimStructureSections(StructurifyChunkGenerator gen, long[] sectionKeysToClaim, ResourceLocation structureId, long structureCenter) {
        long token = ThreadLocalRandom.current().nextLong();
        StructureSectionClaim claim = new StructureSectionClaim(token, structureId.toString(), structureCenter);
        long[] claimed = new long[sectionKeysToClaim.length];
        for (int acquired = 0; acquired < sectionKeysToClaim.length; ++acquired) {
            long key;
            claimed[acquired] = key = sectionKeysToClaim[acquired];
            StructureSectionClaim prev = gen.structurify$getStructureSectionClaims().putIfAbsent(key, claim);
            if (prev == null || structureId.toString().equals(prev.structureId()) && structureCenter == prev.structureCenter()) continue;
            for (int i = 0; i < acquired; ++i) {
                gen.structurify$getStructureSectionClaims().remove(claimed[i], claim);
            }
            return false;
        }
        return true;
    }
}

