/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.debug;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.DebugData;
import com.faboslav.structurify.common.mixin.structure.pools.SinglePoolElementAccessor;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckSample;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckSample;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class StructurifyDebugRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Minecraft minecraft, PoseStack poseStack, @Nullable MultiBufferSource bufferSource) {
        DebugData debugData = Structurify.getConfig().getDebugData();
        if (!debugData.isEnabled()) {
            return;
        }
        DebugData.DebugMode debugMode = debugData.getDebugMode();
        if (bufferSource == null) {
            bufferSource = minecraft.m_91269_().m_110104_();
        }
        int viewDistance = minecraft.m_91092_().m_6846_().m_11312_();
        int chunkRadius = Math.max(1, viewDistance);
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 cameraPosition = camera.m_90583_();
        BlockPos cameraBlockPosition = BlockPos.m_274446_((Position)cameraPosition);
        double camX = cameraPosition.f_82479_;
        double camY = cameraPosition.f_82480_;
        double camZ = cameraPosition.f_82481_;
        if (debugMode == DebugData.DebugMode.FLATNESS) {
            Map<Long, StructureFlatnessCheckOverview> structureFlatnessCheckOverviews;
            Map<Long, StructureFlatnessCheckOverview> map = structureFlatnessCheckOverviews = Structurify.getConfig().getDebugData().getStructureFlatnessCheckOverviews();
            synchronized (map) {
                for (StructureFlatnessCheckOverview structureFlatnessCheckOverview : structureFlatnessCheckOverviews.values().stream().filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.structureBoundingBox().m_162394_(), chunkRadius)).toList()) {
                    this.renderStructureFlatnessCheckOverview(structureFlatnessCheckOverview, minecraft, poseStack, bufferSource, camX, camY, camZ);
                }
            }
            Map<Long, Set<StructureFlatnessCheckSample>> structureFlatnessCheckSamples = Structurify.getConfig().getDebugData().getStructureFlatnessCheckSamples();
            Map<Long, Set<StructureFlatnessCheckSample>> map2 = structureFlatnessCheckSamples;
            synchronized (map2) {
                for (StructureFlatnessCheckSample structureFlatnessCheckSample : structureFlatnessCheckSamples.values().stream().flatMap(Collection::stream).filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.x(), o.freeY(), o.z(), chunkRadius)).toList()) {
                    this.renderStructureFlatnessCheckSample(structureFlatnessCheckSample, poseStack, bufferSource, camX, camY, camZ);
                }
            }
        }
        if (debugMode == DebugData.DebugMode.BIOME) {
            Map<Long, StructureBiomeCheckOverview> structureBiomeCheckOverviews;
            Map<Long, StructureBiomeCheckOverview> structureFlatnessCheckSamples = structureBiomeCheckOverviews = Structurify.getConfig().getDebugData().getStructureBiomeCheckOverviews();
            synchronized (structureFlatnessCheckSamples) {
                for (StructureBiomeCheckOverview structureBiomeCheckOverview : structureBiomeCheckOverviews.values().stream().filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.structureBoundingBox().m_162394_(), chunkRadius)).toList()) {
                    this.renderStructureBiomeCheckOverview(structureBiomeCheckOverview, minecraft, poseStack, bufferSource, camX, camY, camZ);
                }
            }
            Map<Long, Set<StructureBiomeCheckSample>> structureBiomeCheckSamples = Structurify.getConfig().getDebugData().getStructureBiomeCheckSamples();
            Map<Long, Set<StructureBiomeCheckSample>> map = structureBiomeCheckSamples;
            synchronized (map) {
                for (StructureBiomeCheckSample structureBiomeCheckSample : structureBiomeCheckSamples.values().stream().flatMap(Collection::stream).filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.x(), o.y(), o.z(), chunkRadius)).toList()) {
                    this.renderStructureBiomeCheckSample(structureBiomeCheckSample, poseStack, bufferSource, camX, camY, camZ);
                }
            }
        }
    }

    private void renderStructureFlatnessCheckOverview(StructureFlatnessCheckOverview structureFlatnessCheckOverview, Minecraft minecraft, PoseStack poseStack, MultiBufferSource bufferSource, double camX, double camY, double camZ) {
        BoundingBox structureBoundingBox = structureFlatnessCheckOverview.structureBoundingBox();
        StructurifyDebugRenderer.renderBoundingBox(structureBoundingBox, poseStack, bufferSource.m_6299_(RenderType.m_110504_()), camX, camY, camZ, 0.8f);
        this.renderLabel(structureBoundingBox, structureFlatnessCheckOverview.toString(), minecraft, poseStack, bufferSource, camX, camY, camZ);
        this.renderStructurePiecesForOverview(structureBoundingBox, structureFlatnessCheckOverview.structurePieces(), minecraft, poseStack, bufferSource, camX, camY, camZ);
    }

    private void renderStructureBiomeCheckOverview(StructureBiomeCheckOverview structureBiomeCheckOverview, Minecraft minecraft, PoseStack poseStack, MultiBufferSource bufferSource, double camX, double camY, double camZ) {
        BoundingBox structureBoundingBox = structureBiomeCheckOverview.structureBoundingBox();
        StructurifyDebugRenderer.renderBoundingBox(structureBoundingBox, poseStack, bufferSource.m_6299_(RenderType.m_110504_()), camX, camY, camZ, 0.8f);
        this.renderLabel(structureBoundingBox, structureBiomeCheckOverview.toString(), minecraft, poseStack, bufferSource, camX, camY, camZ);
        this.renderStructurePiecesForOverview(structureBoundingBox, structureBiomeCheckOverview.structurePieces(), minecraft, poseStack, bufferSource, camX, camY, camZ);
    }

    private void renderStructurePiecesForOverview(BoundingBox structureBoundingBox, List<StructurePiece> structurePieces, Minecraft minecraft, PoseStack poseStack, MultiBufferSource bufferSource, double camX, double camY, double camZ) {
        for (StructurePiece structurePiece : structurePieces) {
            BoundingBox structurePieceBoundingBox = structurePiece.m_73547_();
            if (structurePieceBoundingBox.equals((Object)structureBoundingBox)) continue;
            StructurifyDebugRenderer.renderBoundingBox(structurePieceBoundingBox, poseStack, bufferSource.m_6299_(RenderType.m_110504_()), camX, camY, camZ, 0.2f);
            String pieceName = "";
            if (structurePiece instanceof PoolElementStructurePiece) {
                PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)structurePiece;
                StructurePoolElement element = poolPiece.m_209918_();
                if (element instanceof SinglePoolElement) {
                    SinglePoolElement single = (SinglePoolElement)element;
                    ResourceLocation template = ((SinglePoolElementAccessor)single).getTemplate().left().orElse(null);
                    if (template != null) {
                        pieceName = template.toString();
                    }
                } else {
                    pieceName = "";
                }
            }
            this.renderLabel(structurePieceBoundingBox, pieceName, minecraft, poseStack, bufferSource, camX, camY, camZ);
        }
    }

    private void renderStructureFlatnessCheckSample(StructureFlatnessCheckSample structureFlatnessCheckSample, PoseStack poseStack, MultiBufferSource bufferSource, double camX, double camY, double camZ) {
        int x = structureFlatnessCheckSample.x();
        int z = structureFlatnessCheckSample.z();
        int occY = structureFlatnessCheckSample.occY();
        int freeY = Math.max(structureFlatnessCheckSample.freeY(), occY + 1);
        boolean solid = structureFlatnessCheckSample.isSolid();
        float r = solid ? 0.2f : 1.0f;
        float g = solid ? 1.0f : 0.2f;
        float b = 0.2f;
        float a = 0.95f;
        AABB col = new AABB((double)x, (double)occY, (double)z, (double)(x + 1), (double)freeY, (double)(z + 1)).m_82386_(-camX, -camY, -camZ);
        StructurifyDebugRenderer.renderLineBox(poseStack, bufferSource.m_6299_(RenderType.m_110504_()), col, r, g, 0.2f, 0.95f);
    }

    private void renderStructureBiomeCheckSample(StructureBiomeCheckSample structureBiomeCheckSample, PoseStack poseStack, MultiBufferSource bufferSource, double camX, double camY, double camZ) {
        int x = structureBiomeCheckSample.x();
        int y = structureBiomeCheckSample.y();
        int z = structureBiomeCheckSample.z();
        boolean result = structureBiomeCheckSample.result();
        float r = result ? 0.2f : 1.0f;
        float g = result ? 1.0f : 0.2f;
        float b = 0.2f;
        float a = 0.95f;
        AABB col = new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).m_82386_(-camX, -camY, -camZ);
    }

    private static void renderBoundingBox(BoundingBox boundingBox, PoseStack poseStack, VertexConsumer vertexConsumer, double cameraX, double cameraY, double cameraZ, float alpha) {
        AABB aabb = new AABB((double)boundingBox.m_162395_(), (double)boundingBox.m_162396_(), (double)boundingBox.m_162398_(), (double)(boundingBox.m_162399_() + 1), (double)(boundingBox.m_162400_() + 1), (double)(boundingBox.m_162401_() + 1)).m_82386_(-cameraX, -cameraY, -cameraZ);
        StructurifyDebugRenderer.renderLineBox(poseStack, vertexConsumer, aabb, 1.0f, 1.0f, 1.0f, alpha);
    }

    public static void renderLineBox(PoseStack poseStack, VertexConsumer buffer, AABB box, float red, float green, float blue, float alpha) {
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)box, (float)red, (float)green, (float)blue, (float)alpha);
    }

    private void renderLabel(BoundingBox box, String label, Minecraft mc, PoseStack poseStack, MultiBufferSource buffers, double camX, double camY, double camZ) {
        double centerX = (double)(box.m_162395_() + box.m_162399_() + 1) * 0.5;
        double centerZ = (double)(box.m_162398_() + box.m_162401_() + 1) * 0.5;
        double topY = (double)box.m_162400_() + 1.0;
        double labelY = topY + 0.25;
        poseStack.m_85836_();
        poseStack.m_85837_(centerX - camX, labelY - camY, centerZ - camZ);
        poseStack.m_252781_(mc.f_91063_.m_109153_().m_253121_());
        float spanX = box.m_71056_();
        float spanZ = box.m_71058_();
        float diagXZ = (float)Math.sqrt(spanX * spanX + spanZ * spanZ);
        float dynamicScaleFactor = Math.max(1.0f, diagXZ / 24.0f);
        float base = 0.025f;
        float scale = base * dynamicScaleFactor;
        poseStack.m_85841_(-scale, -scale, scale);
        Font font = mc.f_91062_;
        String[] lines = label.split("\n");
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int totalPixelHeight = lines.length * lineHeight;
        float yStart = -totalPixelHeight;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int width = font.m_92895_(line);
            font.m_271703_(line, (float)(-width) / 2.0f, yStart + (float)(i * lineHeight), -1, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        }
        poseStack.m_85849_();
    }

    private static boolean isWithinChunkRadius(BlockPos cameraBlockPos, BlockPos targetBlockPos, int chunkRadius) {
        int camChunkX = SectionPos.m_123171_((int)cameraBlockPos.m_123341_());
        int camChunkZ = SectionPos.m_123171_((int)cameraBlockPos.m_123343_());
        int tgtChunkX = SectionPos.m_123171_((int)targetBlockPos.m_123341_());
        int tgtChunkZ = SectionPos.m_123171_((int)targetBlockPos.m_123343_());
        return Math.max(Math.abs(tgtChunkX - camChunkX), Math.abs(tgtChunkZ - camChunkZ)) <= chunkRadius;
    }

    private static boolean isWithinChunkRadius(BlockPos cameraBlockPos, int targetX, int targetY, int targetZ, int chunkRadius) {
        return StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPos, new BlockPos(targetX, targetY, targetZ), chunkRadius);
    }
}

