/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.registry;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.api.StructurifyStructurePlacement;
import com.faboslav.structurify.common.events.common.UpdateRegistriesEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public final class StructurifyRegistryUpdater {
    public static void updateRegistries(UpdateRegistriesEvent event) {
        if (!Structurify.getConfig().isLoaded) {
            Structurify.getLogger().info("Registries not updated, config not loaded");
            return;
        }
        try {
            Structurify.getLogger().info("Updating registries...");
            HolderLookup.Provider registryManager = event.registryManager();
            if (registryManager == null) {
                Structurify.getLogger().info("Registries not updated, registry manager not loaded");
                return;
            }
            StructurifyRegistryUpdater.updateStructures(registryManager);
            StructurifyRegistryUpdater.updateStructureSets(registryManager);
            Structurify.getLogger().info("Registries updated");
        }
        catch (Exception e) {
            Structurify.getLogger().info("Failed to update registries");
        }
    }

    private static void updateStructures(HolderLookup.Provider registryManager) {
        HolderLookup.RegistryLookup structureRegistry = registryManager.lookup(Registries.STRUCTURE).orElse(null);
        if (structureRegistry == null) {
            return;
        }
        for (Holder.Reference structureReference : structureRegistry.listElements().toList()) {
            Structure structure = (Structure)structureReference.value();
            ResourceKey structureRegistryKey = structureReference.key();
            ResourceLocation structureId = structureRegistryKey.location();
            StructurifyStructure structurifyStructure = (StructurifyStructure)structure;
            structurifyStructure.structurify$setStructureIdentifier(structureId);
        }
        Structurify.getLogger().info("Structure registries updated");
    }

    private static void updateStructureSets(HolderLookup.Provider registryManager) {
        HolderLookup.RegistryLookup structureSetRegistry = registryManager.lookup(Registries.STRUCTURE_SET).orElse(null);
        if (structureSetRegistry == null) {
            return;
        }
        for (Holder.Reference structureSetReference : structureSetRegistry.listElements().toList()) {
            StructureSet structureSet = (StructureSet)structureSetReference.value();
            ResourceKey structureSetRegistryKey = structureSetReference.key();
            ResourceLocation structureSetId = structureSetRegistryKey.location();
            StructurifyStructurePlacement structurifyStructurePlacement = (StructurifyStructurePlacement)structureSet.placement();
            structurifyStructurePlacement.structurify$setStructureSetIdentifier(structureSetId);
        }
        Structurify.getLogger().info("Structure Sets registries updated");
    }
}

