/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.structure.DistanceFromWorldCenterCheckData;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class StructureDistanceFromWorldCenterCheck {
    @Nullable
    public static DistanceFromWorldCenterCheckData getDistanceFromWorldCenterData(class_2960 structureId, StructureData structureData) {
        StructureNamespaceData globalStructureData = Structurify.getConfig().getStructureNamespaceData().get(StructureNamespaceData.GLOBAL_NAMESPACE_IDENTIFIER);
        StructureNamespaceData namespacedStructureData = Structurify.getConfig().getStructureNamespaceData().get(structureId.method_12836());
        DistanceFromWorldCenterCheckData globalDistanceFromWorldCenterData = globalStructureData.getDistanceFromWorldCenterCheckData();
        DistanceFromWorldCenterCheckData namespaceDistanceFromWorldCenterData = namespacedStructureData.getDistanceFromWorldCenterCheckData();
        DistanceFromWorldCenterCheckData structureDistanceFromWorldCenterData = structureData.getDistanceFromWorldCenterCheckData();
        DistanceFromWorldCenterCheckData distanceFromWorldCenterCheckDataToCheck = globalDistanceFromWorldCenterData;
        if (namespaceDistanceFromWorldCenterData.isOverridingGlobalDistanceFromWorldCenter()) {
            distanceFromWorldCenterCheckDataToCheck = namespaceDistanceFromWorldCenterData;
        }
        if (structureDistanceFromWorldCenterData.isOverridingGlobalDistanceFromWorldCenter()) {
            distanceFromWorldCenterCheckDataToCheck = structureDistanceFromWorldCenterData;
        }
        return distanceFromWorldCenterCheckDataToCheck;
    }

    public static boolean checkDistanceFromWorldCenter(DistanceFromWorldCenterCheckData distanceFromWorldCenterCheckData, class_1923 chunkPos) {
        int minDistanceFromWorldCenter = distanceFromWorldCenterCheckData.getMinDistanceFromWorldCenter();
        int maxDistanceFromWorldCenter = distanceFromWorldCenterCheckData.getMaxDistanceFromWorldCenter();
        if (minDistanceFromWorldCenter == 0 && maxDistanceFromWorldCenter == 0) {
            return true;
        }
        int distanceFromWorldCenter = chunkPos.method_8323().method_19455((class_2382)class_2338.field_10980);
        boolean isFarEnoughFromWorldCenter = minDistanceFromWorldCenter == 0 || distanceFromWorldCenter >= minDistanceFromWorldCenter;
        boolean isCloseEnoughToWorldCenter = maxDistanceFromWorldCenter == 0 || distanceFromWorldCenter <= maxDistanceFromWorldCenter;
        return isFarEnoughFromWorldCenter && isCloseEnoughToWorldCenter;
    }
}

