/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.controller;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.StructurifyClient;
import com.faboslav.structurify.common.config.client.gui.StructureConfigScreen;
import com.faboslav.structurify.common.config.client.gui.StructurifyConfigScreen;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.BooleanController;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class StructureButtonController
extends BooleanController {
    private final String structureId;

    public StructureButtonController(Option<Boolean> option, String structureId, Function<Boolean, Component> valueFormatter, boolean coloured) {
        super(option, valueFormatter, coloured);
        this.structureId = structureId;
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new BooleanWithButtonControllerElement(this, screen, widgetDimension, this.structureId);
    }

    public static class BooleanWithButtonControllerElement
    extends BooleanController.BooleanControllerElement {
        private final TextScaledButtonWidget configurationButton;

        public BooleanWithButtonControllerElement(BooleanController control, YACLScreen screen, Dimension<Integer> dim, String structureId) {
            super(control, screen, dim);
            this.setDimension(this.getDimension().expanded((Number)-20, (Number)0));
            this.configurationButton = new TextScaledButtonWidget((Screen)screen, ((Integer)this.getDimension().xLimit()).intValue(), -50, 20, 20, 1.0f, (Component)Component.literal((String)"\u2699").withStyle(style -> style.withBold(Boolean.valueOf(true))), button -> {
                StructurifyConfigScreen configScreen = StructurifyClient.getConfigScreen();
                if (configScreen == null) {
                    return;
                }
                screen.finishOrSave();
                YACLScreen structureScreen = StructureConfigScreen.create(Structurify.getConfig(), structureId, (Screen)screen);
                configScreen.saveScreenState(screen);
                this.client.setScreen((Screen)structureScreen);
                configScreen.loadScreenState(structureScreen);
            });
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.configurationButton.setY(((Integer)this.getDimension().y()).intValue());
            this.configurationButton.render(graphics, mouseX, mouseY, delta);
            this.configurationButton.active = this.isAvailable();
            super.render(graphics, mouseX, mouseY, delta);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.configurationButton.isMouseOver(mouseX, mouseY) || super.isMouseOver(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
            return this.configurationButton.mouseClicked(mouseButtonEvent, doubleClick) || super.mouseClicked(mouseButtonEvent, doubleClick);
        }

        public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
            return this.configurationButton.mouseReleased(mouseButtonEvent) || super.mouseReleased(mouseButtonEvent);
        }

        public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dx, double dy) {
            return this.configurationButton.mouseDragged(mouseButtonEvent, dx, dy) || super.mouseDragged(mouseButtonEvent, dx, dy);
        }
    }
}

