/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.data.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BiomeCheckData {
    public static final boolean OVERRIDE_GLOBAL_BIOME_CHECK_DEFAULT_VALUE = false;
    public static final boolean IS_ENABLED_DEFAULT_VALUE = false;
    public static final BiomeCheckMode MODE_DEFAULT_VALUE = BiomeCheckMode.BLACKLIST;
    public static final List<String> BLACKLISTED_BIOMES_DEFAULT_VALUE = List.of("#minecraft:is_river", "#c:is_river", "#minecraft:is_ocean", "#c:is_ocean");
    private boolean overrideGlobalBiomeCheck = false;
    private boolean isEnabled = false;
    private BiomeCheckMode mode = MODE_DEFAULT_VALUE;
    private List<String> blacklistedBiomes = BLACKLISTED_BIOMES_DEFAULT_VALUE;

    public boolean isUsingDefaultValues() {
        ArrayList<String> blacklistedBiomes = new ArrayList<String>(this.blacklistedBiomes);
        ArrayList<String> defaultBlacklistedBiomes = new ArrayList<String>(BLACKLISTED_BIOMES_DEFAULT_VALUE);
        Collections.sort(blacklistedBiomes);
        Collections.sort(defaultBlacklistedBiomes);
        return !this.overrideGlobalBiomeCheck && !this.isEnabled && this.mode == MODE_DEFAULT_VALUE && blacklistedBiomes.equals(defaultBlacklistedBiomes);
    }

    public boolean isOverridingGlobalBiomeCheck() {
        return this.overrideGlobalBiomeCheck;
    }

    public void overrideGlobalBiomeCheck(boolean overrideGlobalBiomeCheck) {
        this.overrideGlobalBiomeCheck = overrideGlobalBiomeCheck;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void enable(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public BiomeCheckMode getMode() {
        return this.mode;
    }

    public void setMode(BiomeCheckMode mode) {
        this.mode = mode;
    }

    public List<String> getBlacklistedBiomes() {
        return this.blacklistedBiomes;
    }

    public void setBlacklistedBiomes(List<String> blacklistedBiomes) {
        this.blacklistedBiomes = blacklistedBiomes;
    }

    public static enum BiomeCheckMode {
        STRICT,
        BLACKLIST;

    }
}

