/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionfc;

public final class RenderUtil {
    public static void renderBoundingBox(BoundingBox boundingBox, PoseStack poseStack, VertexConsumer vertexConsumer, double cameraX, double cameraY, double cameraZ, float alpha) {
        AABB aabb = new AABB((double)boundingBox.minX(), (double)boundingBox.minY(), (double)boundingBox.minZ(), (double)(boundingBox.maxX() + 1), (double)(boundingBox.maxY() + 1), (double)(boundingBox.maxZ() + 1)).move(-cameraX, -cameraY, -cameraZ);
        RenderUtil.renderLineBox(poseStack, vertexConsumer, aabb, 1.0f, 1.0f, 1.0f, alpha);
    }

    public static void renderLineBox(PoseStack poseStack, VertexConsumer buffer, AABB box, float red, float green, float blue, float alpha) {
        ShapeRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)box, (float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void renderLabel(BoundingBox box, String label, Minecraft mc, PoseStack poseStack, MultiBufferSource buffers, double camX, double camY, double camZ) {
        RenderUtil.renderLabel(box, label, mc, poseStack, buffers, camX, camY, camZ, false);
        RenderUtil.renderLabel(box, label, mc, poseStack, buffers, camX, camY, camZ, true);
    }

    private static void renderLabel(BoundingBox box, String label, Minecraft mc, PoseStack poseStack, MultiBufferSource buffers, double camX, double camY, double camZ, boolean inverse) {
        double centerX = (double)(box.minX() + box.maxX() + 1) * 0.5;
        double centerZ = (double)(box.minZ() + box.maxZ() + 1) * 0.5;
        double topY = (double)box.maxY() + 1.0;
        double labelY = topY + 0.25;
        poseStack.pushPose();
        poseStack.translate(centerX - camX, labelY - camY, centerZ - camZ);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - (inverse ? 180.0f : 0.0f)));
        float spanX = box.getXSpan();
        float spanZ = box.getZSpan();
        float diagXZ = (float)Math.sqrt(spanX * spanX + spanZ * spanZ);
        float base = 0.03f;
        float dynamic = Math.max(1.0f, diagXZ / 24.0f);
        float scale = Math.max(base, base * dynamic);
        poseStack.scale(-scale, -scale, scale);
        Font font = mc.font;
        String[] lines = label.split("\n");
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int totalPixelHeight = lines.length * lineHeight;
        float yStart = -totalPixelHeight;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int width = font.width(line);
            font.drawInBatch(line, (float)(-width) / 2.0f, yStart + (float)(i * lineHeight), -1, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        poseStack.popPose();
    }
}

