/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui.structure;

import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.BiomeStringControllerBuilder;
import com.faboslav.structurify.common.config.data.StructureLikeData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class BiomeCheckOptions {
    public static String OVERRIDE_GLOBAL_BIOME_CHECK_OPTION_NAME = "override_global_biome_check";
    public static String BIOME_CHECK_IS_ENABLED_OPTION_NAME = "is_enabled";
    public static String BIOME_CHECK_MODE_OPTION_NAME = "mode";
    public static String BIOME_CHECK_BLACKLISTED_BIOMES_OPTION_NAME = "blacklisted_biomes";

    public static Map<String, Option<?>> addBiomeCheckOptions(ConfigCategory.Builder categoryBuilder, OptionGroup.Builder groupBuilder, StructurifyConfig config, String id) {
        Option isOverridingGlobalBiomeCheckOption;
        Map<String, StructureLikeData> structureLikeData;
        String namespace;
        boolean isNamespace;
        boolean isEnabledGlobally = config.getStructureNamespaceData().get(StructureNamespaceData.GLOBAL_NAMESPACE_IDENTIFIER).getBiomeCheckData().isEnabled();
        boolean isGlobal = id.equals(StructureNamespaceData.GLOBAL_NAMESPACE_IDENTIFIER);
        boolean isEnabledForNamespace = config.getStructureNamespaceData().get(id.split(":")[0]).getBiomeCheckData().isEnabled();
        boolean bl = isNamespace = !id.contains(":");
        if (isNamespace) {
            namespace = id;
            structureLikeData = config.getStructureNamespaceData();
        } else {
            namespace = id.split(":")[0];
            structureLikeData = config.getStructureData();
        }
        HashMap biomeCheckOptions = new HashMap();
        BiomeCheckData biomeCheckData = structureLikeData.get(id).getBiomeCheckData();
        boolean isEnabled = structureLikeData.get(id).getBiomeCheckData().isEnabled();
        MutableComponent title = Component.translatable((String)"gui.structurify.structures.biome_check_group.title");
        if (isGlobal || isNamespace) {
            title = Component.literal((String)("\u201e" + LanguageUtil.translateId(null, namespace).getString() + "\u201c ")).append((Component)title);
        }
        title = Component.literal((String)"\n").append((Component)title);
        groupBuilder.option((Option)LabelOption.create((Component)title.withStyle(style -> style.withBold(Boolean.valueOf(true)))));
        if (!isGlobal) {
            isOverridingGlobalBiomeCheckOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.override_global_biome_check.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.override_global_biome_check.description", (Object[])new Object[]{namespace, id})})).available(isEnabledGlobally || isEnabledForNamespace).binding((Object)false, () -> ((StructureLikeData)structureLikeData.get(id)).getBiomeCheckData().isOverridingGlobalBiomeCheck(), overrideGlobalBiomeCheck -> ((StructureLikeData)structureLikeData.get(id)).getBiomeCheckData().overrideGlobalBiomeCheck((boolean)overrideGlobalBiomeCheck)).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.translatable((String)"gui.structurify.label.yes") : Component.translatable((String)"gui.structurify.label.no"))).coloured(true)).build();
            biomeCheckOptions.put(OVERRIDE_GLOBAL_BIOME_CHECK_OPTION_NAME, isOverridingGlobalBiomeCheckOption);
            groupBuilder.option(isOverridingGlobalBiomeCheckOption);
        } else {
            isOverridingGlobalBiomeCheckOption = null;
        }
        Option isEnabledOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.enable_biome_check.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.enable_biome_check.description")})).available(isGlobal || biomeCheckData.isOverridingGlobalBiomeCheck() || !isEnabledGlobally && !isEnabledForNamespace).binding((Object)false, biomeCheckData::isEnabled, biomeCheckData::enable).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.translatable((String)"gui.structurify.label.yes") : Component.translatable((String)"gui.structurify.label.no"))).coloured(true)).build();
        biomeCheckOptions.put(BIOME_CHECK_IS_ENABLED_OPTION_NAME, isEnabledOption);
        groupBuilder.option(isEnabledOption);
        Option modeOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.biome_check_mode.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.biome_check_mode.description")})).available(biomeCheckData.isEnabled()).binding((Object)BiomeCheckData.MODE_DEFAULT_VALUE, biomeCheckData::getMode, biomeCheckData::setMode).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(BiomeCheckData.BiomeCheckMode.class).valueFormatter(biomeCheckMode -> Component.translatable((String)("gui.structurify.structures.structure.biome_check_mode." + biomeCheckMode.name().toLowerCase())))).build();
        biomeCheckOptions.put(BIOME_CHECK_MODE_OPTION_NAME, modeOption);
        groupBuilder.option(modeOption);
        ListOption blacklistedBiomesOption = ListOption.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structure.biome_check_blacklisted_biomes.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structure.biome_check_blacklisted_biomes.description")})).available(biomeCheckData.isEnabled()).collapsed(false).insertEntriesAtEnd(false).binding(BiomeCheckData.BLACKLISTED_BIOMES_DEFAULT_VALUE, () -> biomeCheckData.getBlacklistedBiomes(), blacklistedBiomes -> biomeCheckData.setBlacklistedBiomes((List<String>)blacklistedBiomes)).controller(BiomeStringControllerBuilder::create).available(biomeCheckData.getMode() == BiomeCheckData.BiomeCheckMode.BLACKLIST).initial((Object)"").build();
        blacklistedBiomesOption.setAvailable(biomeCheckData.isEnabled());
        biomeCheckOptions.put(BIOME_CHECK_BLACKLISTED_BIOMES_OPTION_NAME, (Option<?>)blacklistedBiomesOption);
        if (isOverridingGlobalBiomeCheckOption != null) {
            isOverridingGlobalBiomeCheckOption.addListener((opt, currentOverrideGlobalBiomeCheck) -> {
                isEnabledOption.setAvailable(currentOverrideGlobalBiomeCheck.booleanValue());
                if (!currentOverrideGlobalBiomeCheck.booleanValue()) {
                    isEnabledOption.requestSetDefault();
                }
            });
        }
        isEnabledOption.addListener((opt, currentIsEnabled) -> {
            boolean isBlacklistAvailable = biomeCheckData.getMode() == BiomeCheckData.BiomeCheckMode.BLACKLIST;
            modeOption.setAvailable(currentIsEnabled.booleanValue());
            blacklistedBiomesOption.setAvailable(currentIsEnabled != false && isBlacklistAvailable);
        });
        modeOption.addListener((opt, biomeCheckMode) -> {
            boolean isBlacklistAvailable = biomeCheckMode == BiomeCheckData.BiomeCheckMode.BLACKLIST;
            blacklistedBiomesOption.setAvailable(isBlacklistAvailable);
        });
        return biomeCheckOptions;
    }
}

