/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.commands;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.DebugData;
import com.faboslav.structurify.common.mixin.LocateCommandInvoker;
import com.faboslav.structurify.world.level.structure.checks.StructureChecker;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2818;
import net.minecraft.class_3079;
import net.minecraft.class_3195;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7138;
import net.minecraft.class_7157;
import net.minecraft.class_7924;

public final class StructurifyCommand {
    private static final SuggestionProvider<class_2168> DEBUG_MODE_SUGGESTIONS = (ctx, builder) -> class_2172.method_9264(DebugData.DebugMode.getNames(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> SAMPLING_MODE_SUGGESTIONS = (ctx, builder) -> class_2172.method_9264(DebugData.SamplingMode.getNames(), (SuggestionsBuilder)builder);

    public static void createCommand(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"structurify").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"dump").executes(ctx -> {
            Structurify.getConfig().dump();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Structurify config dumped to \"" + String.valueOf(Structurify.getConfig().configDumpPath) + "\".")), !((class_2168)ctx.getSource()).method_43737());
            return 1;
        }))).then(class_2170.method_9247((String)"locate").then(class_2170.method_9247((String)"structure").then(class_2170.method_9244((String)"structure", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41246)).executes(commandContext -> StructurifyCommand.locateStructure((class_2168)commandContext.getSource(), (class_7066.class_7068<class_3195>)class_7066.method_41166((CommandContext)commandContext, (String)"structure", (class_5321)class_7924.field_41246, (DynamicCommandExceptionType)LocateCommandInvoker.structurify$getStructureInvalidError()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enable").requires(src -> src.method_9259(2))).executes(ctx -> {
            Structurify.getConfig().getDebugData().setEnabled(true);
            Structurify.getConfig().getDebugData().setDebugMode(DebugData.DebugMode.FLATNESS);
            Structurify.getConfig().getDebugData().setSamplingMode(DebugData.SamplingMode.FINAL);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Structurify debug enabled."), !((class_2168)ctx.getSource()).method_43737());
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"disable").requires(src -> src.method_9259(2))).executes(ctx -> {
            Structurify.getConfig().getDebugData().setEnabled(false);
            Structurify.getConfig().getDebugData().setDebugMode(DebugData.DebugMode.NONE);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Structurify debug disabled."), !((class_2168)ctx.getSource()).method_43737());
            return 1;
        }))).then(class_2170.method_9247((String)"debug_mode").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"debugMode", (ArgumentType)StringArgumentType.word()).suggests(DEBUG_MODE_SUGGESTIONS).requires(src -> src.method_9259(2))).executes(ctx -> {
            DebugData.DebugMode debugMode;
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"debugMode");
            try {
                debugMode = DebugData.DebugMode.valueOf(raw.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unknown debug mode: " + raw)));
                return 0;
            }
            Structurify.getConfig().getDebugData().setDebugMode(debugMode);
            StructurifyCommand.reloadStructureChecks((CommandContext<class_2168>)ctx);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Structurify debug mode changed to " + String.valueOf((Object)debugMode) + ".")), !((class_2168)ctx.getSource()).method_43737());
            return 1;
        })))).then(class_2170.method_9247((String)"sampling_mode").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"samplingMode", (ArgumentType)StringArgumentType.word()).suggests(SAMPLING_MODE_SUGGESTIONS).requires(src -> src.method_9259(2))).executes(ctx -> {
            DebugData.SamplingMode samplingMode;
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"samplingMode");
            try {
                samplingMode = DebugData.SamplingMode.valueOf(raw.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unknown sampling mode: " + raw)));
                return 0;
            }
            Structurify.getConfig().getDebugData().setSamplingMode(samplingMode);
            Structurify.getConfig().getDebugData().clearStructureFlatnessCheckOverviews();
            Structurify.getConfig().getDebugData().clearStructureFlatnessCheckSamples();
            Structurify.getConfig().getDebugData().clearStructureBiomeCheckOverviews();
            Structurify.getConfig().getDebugData().clearStructureBiomeCheckSamples();
            StructurifyCommand.reloadStructureChecks((CommandContext<class_2168>)ctx);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Structurify debug sampling mode changed to " + String.valueOf((Object)samplingMode) + ".")), !((class_2168)ctx.getSource()).method_43737());
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"structures").requires(src -> src.method_9259(2))).executes(ctx -> StructurifyCommand.getStructures((class_2168)ctx.getSource())))));
    }

    private static void reloadStructureChecks(CommandContext<class_2168> ctx) {
        class_3218 serverLevel = ((class_2168)ctx.getSource()).method_9225();
        class_2338 blockPos = class_2338.method_49638((class_2374)((class_2168)ctx.getSource()).method_9222());
        class_1923 center = new class_1923(blockPos);
        class_3215 chunkSource = serverLevel.method_14178();
        class_2794 chunkGenerator = chunkSource.method_12129();
        class_1966 biomeSource = chunkGenerator.method_12098();
        class_7138 randomState = chunkSource.method_41248();
        int viewDistance = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14568();
        int chunkRadius = Math.max(1, (int)((double)viewDistance * 1.33));
        for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
            for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
                class_1923 chunkPos = new class_1923(center.field_9181 + dx, center.field_9180 + dz);
                class_2818 chunk = chunkSource.method_21730(chunkPos.field_9181, chunkPos.field_9180);
                if (chunk == null) continue;
                for (Map.Entry structureStartEntry : chunk.method_12016().entrySet()) {
                    StructureChecker.debugCheckStructure((class_3449)structureStartEntry.getValue(), (StructurifyStructure)structureStartEntry.getKey(), chunkGenerator, (class_5539)serverLevel, randomState, biomeSource);
                }
            }
        }
    }

    private static int getStructures(class_2168 source) {
        class_3218 level = source.method_9225();
        class_2338 pos = class_2338.method_49638((class_2374)source.method_9222());
        return 0;
    }

    private static int locateStructure(class_2168 source, class_7066.class_7068<class_3195> structure) throws CommandSyntaxException {
        class_3218 serverLevel = source.method_9225();
        class_2338 blockPos = class_2338.method_49638((class_2374)source.method_9222());
        class_2378 registry = source.method_9225().method_30349().method_30530(class_7924.field_41246);
        class_6885 holderSet = (class_6885)LocateCommandInvoker.structurify$invokeGetHolders(structure, (class_2378<class_3195>)registry).orElseThrow(() -> LocateCommandInvoker.structurify$getStructureInvalidError().create((Object)structure.method_41176()));
        source.method_9226(() -> class_2561.method_43470((String)("Locating " + structure.method_41176() + " in the radius of 6400 chunks")), false);
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)class_156.field_37250);
        CompletableFuture.supplyAsync(() -> serverLevel.method_14178().method_12129().method_12103(serverLevel, holderSet, blockPos, 6400, false), class_156.method_18349()).thenAcceptAsync(pair -> {
            stopwatch.stop();
            source.method_9211().execute(() -> {
                if (pair == null) {
                    source.method_9213((class_2561)class_2561.method_43471((String)LocateCommandInvoker.structurify$getStructureNotFoundError().create((Object)structure.method_41176()).getLocalizedMessage()));
                } else {
                    class_3079.method_24499((class_2168)source, (class_7066.class_7068)structure, (class_2338)blockPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
                }
            });
        }, (Executor)class_156.method_18349());
        return 0;
    }
}

