/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.DualControllerBuilder;
import com.faboslav.structurify.common.config.client.api.option.HolderOption;
import com.faboslav.structurify.common.config.client.api.option.InvisibleOptionGroup;
import com.faboslav.structurify.common.config.client.api.option.OptionPair;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.util.LanguageUtil;
import com.faboslav.structurify.common.util.TextUtil;
import com.faboslav.structurify.common.util.YACLUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public final class StructureSetsConfigScreen {
    public static Map<String, AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>>> structureSetOptions = new HashMap<String, AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>>>();
    public static Option<Boolean> enableGlobalSpacingAndSeparationOption = null;
    public static Option<Double> globalSpacingAndSeparationModifierOption = null;

    public static void createStructureSetsTab(YetAnotherConfigLib.Builder yacl, StructurifyConfig config) {
        ConfigCategory.Builder structureSetCategoryBuilder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets_category.title")).tooltip(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structure_sets_category.description").method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.spacing.description")).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.separation.description"))});
        StructureSetsConfigScreen.addGlobalOptions(structureSetCategoryBuilder, config);
        Map<String, StructureSetData> structureSets = WorldgenDataProvider.getStructureSets();
        ArrayList<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
        OptionGroup.Builder currentGroupBuilder = null;
        String currentNamespace = null;
        for (Map.Entry<String, StructureSetData> entry : structureSets.entrySet()) {
            String structureSetStringId = entry.getKey();
            class_2960 structureSetId = Structurify.makeNamespacedId(structureSetStringId);
            String namespace = structureSetId.method_12836();
            if (!namespace.equals(currentNamespace)) {
                if (currentGroupBuilder != null) {
                    optionGroups.add(currentGroupBuilder.build());
                }
                currentGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43469((String)"gui.structurify.structure_sets.structure_group.title", (Object[])new Object[]{LanguageUtil.translateId(null, namespace)}).method_27694(style -> style.method_30938(Boolean.valueOf(true)))).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43469((String)"gui.structurify.structure_sets.structure_group.description", (Object[])new Object[]{namespace})}));
                currentNamespace = namespace;
            }
            class_5250 translatedStructureSetName = LanguageUtil.translateId("structure", structureSetStringId);
            currentGroupBuilder.option((Option)LabelOption.createBuilder().line((class_2561)translatedStructureSetName.method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)))).build());
            int defaultSalt = config.getStructureSetData().get(structureSetStringId).getDefaultSalt();
            if (defaultSalt != 0) {
                OptionDescription.Builder saltDescriptionBuilder = OptionDescription.createBuilder();
                saltDescriptionBuilder.text(new class_2561[]{TextUtil.createTextWithPrefix(translatedStructureSetName, "gui.structurify.structure_sets.salt.description")});
                Option saltOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.salt.title")).description(saltDescriptionBuilder.build()).binding((Object)config.getStructureSetData().get(structureSetStringId).getDefaultSalt(), () -> config.getStructureSetData().get(structureSetStringId).getSalt(), salt -> config.getStructureSetData().get(structureSetStringId).setSalt((int)salt)).controller(opt -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)opt).range((Number)0, (Number)Integer.MAX_VALUE)).formatValue(value -> class_2561.method_43470((String)value.toString()))).build();
                currentGroupBuilder.option(saltOption);
            }
            OptionDescription.Builder frequencyDescriptionBuilder = OptionDescription.createBuilder();
            frequencyDescriptionBuilder.text(new class_2561[]{TextUtil.createTextWithPrefix(translatedStructureSetName, "gui.structurify.structure_sets.frequency.description")});
            float defaultFrequency = config.getStructureSetData().get(structureSetStringId).getDefaultFrequency();
            if (defaultFrequency != 0.0f) {
                Option frequencyOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.frequency.title")).description(frequencyDescriptionBuilder.build()).binding((Object)Float.valueOf(config.getStructureSetData().get(structureSetStringId).getDefaultFrequency()), () -> Float.valueOf(config.getStructureSetData().get(structureSetStringId).getFrequency()), frequency -> config.getStructureSetData().get(structureSetStringId).setFrequency(frequency.floatValue())).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.001f))).formatValue(value -> class_2561.method_43470((String)String.format(Locale.ROOT, "%.3f", value)))).build();
                currentGroupBuilder.option(frequencyOption);
            }
            int defaultSpacing = config.getStructureSetData().get(structureSetStringId).getDefaultSpacing();
            int defaultSeparation = config.getStructureSetData().get(structureSetStringId).getDefaultSeparation();
            if (defaultSpacing != 0 && defaultSeparation != 0) {
                OptionDescription.Builder overrideGlobalSpacingAndSeparationModifierDescriptionBuilder = OptionDescription.createBuilder();
                overrideGlobalSpacingAndSeparationModifierDescriptionBuilder.text(new class_2561[]{TextUtil.createTextWithPrefix(translatedStructureSetName, class_2561.method_43469((String)"gui.structurify.structure_sets.override_global_spacing_and_separation_modifier.description", (Object[])new Object[]{translatedStructureSetName}))});
                Option overrideGlobalSpacingAndSeparationModifierOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.override_global_spacing_and_separation_modifier.title")).description(overrideGlobalSpacingAndSeparationModifierDescriptionBuilder.build()).binding((Object)false, () -> config.getStructureSetData().get(structureSetStringId).overrideGlobalSpacingAndSeparationModifier(), overrideGlobalSpacingAndSeparationModifier -> config.getStructureSetData().get(structureSetStringId).setOverrideGlobalSpacingAndSeparationModifier((boolean)overrideGlobalSpacingAndSeparationModifier)).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).formatValue(val -> val != false ? class_2561.method_43471((String)"gui.structurify.label.yes") : class_2561.method_43471((String)"gui.structurify.label.no"))).coloured(true)).available(config.enableGlobalSpacingAndSeparationModifier).build();
                overrideGlobalSpacingAndSeparationModifierOption.addListener((opt, enableGlobalSpacingAndSeparationModifier) -> {
                    boolean available = enableGlobalSpacingAndSeparationModifier;
                    AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>> structureSetOption = structureSetOptions.get(structureSetStringId);
                    structureSetOption.getValue().setAvailable(available);
                });
                OptionDescription.Builder spacingDescriptionBuilder = OptionDescription.createBuilder();
                spacingDescriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structure_sets.spacing.description")});
                Option spacingOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.spacing.title")).description(spacingDescriptionBuilder.build()).binding((Object)config.getStructureSetData().get(structureSetStringId).getDefaultSpacing(), () -> config.getStructureSetData().get(structureSetStringId).getSpacing(), spacing -> config.getStructureSetData().get(structureSetStringId).setSpacing((int)spacing)).controller(opt -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)opt).formatValue(spacing -> {
                    AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>> structureSetOption = structureSetOptions.get(structureSetStringId);
                    Boolean overrideSpacingAndSeparationModifierDescription = (Boolean)structureSetOption.getKey().pendingValue();
                    if (((Boolean)enableGlobalSpacingAndSeparationOption.pendingValue()).booleanValue() && !overrideSpacingAndSeparationModifierDescription.booleanValue()) {
                        spacing = (int)((double)spacing.intValue() * (Double)globalSpacingAndSeparationModifierOption.pendingValue());
                    }
                    return class_2561.method_43470((String)String.valueOf(spacing));
                })).range((Number)0, (Number)1024)).available(!config.enableGlobalSpacingAndSeparationModifier || config.getStructureSetData().get(structureSetStringId).overrideGlobalSpacingAndSeparationModifier()).build();
                OptionDescription.Builder separationDescriptionBuilder = OptionDescription.createBuilder();
                separationDescriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structure_sets.separation.description")});
                separationDescriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.warning")).method_27694(style -> style.method_10977(class_124.field_1054))});
                Option separationOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.separation.title")).description(separationDescriptionBuilder.build()).binding((Object)config.getStructureSetData().get(structureSetStringId).getDefaultSeparation(), () -> config.getStructureSetData().get(structureSetStringId).getSeparation(), separation -> config.getStructureSetData().get(structureSetStringId).setSeparation((int)separation)).controller(opt -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)opt).formatValue(separation -> {
                    AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>> structureSetOption = structureSetOptions.get(structureSetStringId);
                    Boolean overrideSpacingAndSeparationModifierDescription = (Boolean)structureSetOption.getKey().pendingValue();
                    if (((Boolean)enableGlobalSpacingAndSeparationOption.pendingValue()).booleanValue() && !overrideSpacingAndSeparationModifierDescription.booleanValue()) {
                        separation = (int)((double)separation.intValue() * (Double)globalSpacingAndSeparationModifierOption.pendingValue());
                    }
                    return class_2561.method_43470((String)String.valueOf(separation));
                })).range((Number)0, (Number)1024)).available(!config.enableGlobalSpacingAndSeparationModifier || config.getStructureSetData().get(structureSetStringId).overrideGlobalSpacingAndSeparationModifier()).build();
                spacingOption.addListener((opt, spacing) -> {
                    if (spacing <= (Integer)separationOption.pendingValue()) {
                        spacingOption.requestSet((Object)((Integer)separationOption.pendingValue() + 1));
                    }
                });
                separationOption.addListener((opt, separation) -> {
                    if (separation >= (Integer)spacingOption.pendingValue()) {
                        separationOption.requestSet((Object)((Integer)spacingOption.pendingValue() - 1));
                    }
                });
                Option spacingAndSeparationOption = HolderOption.createBuilder().controller(opt -> DualControllerBuilder.create(spacingOption, separationOption)).available(!config.enableGlobalSpacingAndSeparationModifier || config.getStructureSetData().get(structureSetStringId).overrideGlobalSpacingAndSeparationModifier()).build();
                currentGroupBuilder.option(overrideGlobalSpacingAndSeparationModifierOption);
                currentGroupBuilder.option(spacingAndSeparationOption);
                structureSetOptions.put(structureSetStringId, new AbstractMap.SimpleEntry<Option, Option>(overrideGlobalSpacingAndSeparationModifierOption, spacingAndSeparationOption));
            }
            currentGroupBuilder.option((Option)YACLUtil.createEmptyLabelOption(translatedStructureSetName.method_27661()));
        }
        if (currentGroupBuilder != null) {
            OptionGroup builtGroup = currentGroupBuilder.build();
            optionGroups.add(builtGroup);
        }
        for (OptionGroup structureOptionGroup : optionGroups) {
            OptionGroup.Builder invisibleGroup = new InvisibleOptionGroup.Builder().name((class_2561)class_2561.method_43470((String)""));
            invisibleGroup.option((Option)YACLUtil.createEmptyLabelOption());
            structureSetCategoryBuilder.group(invisibleGroup.build());
            structureSetCategoryBuilder.group(structureOptionGroup);
        }
        yacl.category(structureSetCategoryBuilder.build());
    }

    public static void addGlobalOptions(ConfigCategory.Builder categoryBuilder, StructurifyConfig config) {
        OptionGroup.Builder generalStructuresSetsGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.global_spacing_and_separation.title").method_27694(style -> style.method_30938(Boolean.valueOf(true)))).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"gui.structurify.structure_sets.global_spacing_and_separation.description")}));
        generalStructuresSetsGroupBuilder.option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.structure_spread.title").method_27694(style -> style.method_10982(Boolean.valueOf(true)))));
        OptionDescription.Builder enableGlobalSpacingAndSeparationDescriptionBuilder = OptionDescription.createBuilder();
        enableGlobalSpacingAndSeparationDescriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structure_sets.enable_global_spacing_and_separation_modifier.description")});
        enableGlobalSpacingAndSeparationDescriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.warning")).method_27694(style -> style.method_10977(class_124.field_1054))});
        enableGlobalSpacingAndSeparationOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.enable_global_spacing_and_separation_modifier.title")).description(enableGlobalSpacingAndSeparationDescriptionBuilder.build()).binding((Object)false, () -> config.enableGlobalSpacingAndSeparationModifier, enableGlobalSpacingAndSeparationModifier -> {
            config.enableGlobalSpacingAndSeparationModifier = enableGlobalSpacingAndSeparationModifier;
        }).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).formatValue(val -> val != false ? class_2561.method_43471((String)"gui.structurify.label.yes") : class_2561.method_43471((String)"gui.structurify.label.no"))).coloured(true)).build();
        generalStructuresSetsGroupBuilder.option(enableGlobalSpacingAndSeparationOption);
        enableGlobalSpacingAndSeparationOption.addListener((opt, enableGlobalSpacingAndSeparationModifier) -> {
            for (Map.Entry<String, AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>>> structureSetOption : structureSetOptions.entrySet()) {
                Option<Boolean> structureSetOptionOverride = structureSetOption.getValue().getKey();
                Option<OptionPair<Option<Integer>, Option<Integer>>> structureSetOptionPair = structureSetOption.getValue().getValue();
                structureSetOptionOverride.setAvailable(enableGlobalSpacingAndSeparationModifier.booleanValue());
                structureSetOptionPair.setAvailable(enableGlobalSpacingAndSeparationModifier == false || (Boolean)structureSetOptionOverride.pendingValue() != false);
            }
        });
        OptionDescription.Builder globalSpacingAndSeparationModifierDescriptionBuilder = OptionDescription.createBuilder();
        globalSpacingAndSeparationModifierDescriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structure_sets.global_spacing_and_separation_modifier.description")});
        globalSpacingAndSeparationModifierDescriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.warning")).method_27694(style -> style.method_10977(class_124.field_1054))});
        globalSpacingAndSeparationModifierOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structure_sets.global_spacing_and_separation_modifier.title")).description(globalSpacingAndSeparationModifierDescriptionBuilder.build()).binding((Object)1.0, () -> config.globalSpacingAndSeparationModifier, modifier -> {
            config.globalSpacingAndSeparationModifier = modifier;
        }).controller(opt -> DoubleFieldControllerBuilder.create((Option)opt).min((Number)0.1)).build();
        generalStructuresSetsGroupBuilder.option(globalSpacingAndSeparationModifierOption);
        categoryBuilder.group(generalStructuresSetsGroupBuilder.build());
    }
}

