/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.StructureButtonControllerBuilder;
import com.faboslav.structurify.common.config.client.api.option.HolderOption;
import com.faboslav.structurify.common.config.client.api.option.InvisibleOptionGroup;
import com.faboslav.structurify.common.config.client.gui.structure.BiomeCheckOptions;
import com.faboslav.structurify.common.config.client.gui.structure.DistanceFromWorldCenterOptions;
import com.faboslav.structurify.common.config.client.gui.structure.FlatnessCheckOptions;
import com.faboslav.structurify.common.config.client.gui.structure.OverlapCheckOptions;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.common.util.LanguageUtil;
import com.faboslav.structurify.common.util.YACLUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionAddable;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public final class StructuresConfigScreen {
    private static final List<Option<Boolean>> structureOptions = new ArrayList<Option<Boolean>>();
    private static HolderOption<Option<Integer>, Option<Integer>> globalDistanceFromWorldCenterOption = null;
    private static Option<Boolean> enableGlobalFlatnessCheckOption = null;
    private static Option<Boolean> enableGlobalBiomeCheckOption = null;
    private static final List<Option<Boolean>> overrideDistanceFromWorldCenterOptions = new ArrayList<Option<Boolean>>();
    private static final List<Option<Boolean>> overrideFlatnessCheckOptions = new ArrayList<Option<Boolean>>();
    private static final List<Option<Boolean>> overrideBiomeCheckOptions = new ArrayList<Option<Boolean>>();
    private static final List<Option<Boolean>> enableFlatnessCheckOptions = new ArrayList<Option<Boolean>>();
    private static final List<Option<Boolean>> enableBiomeCheckOptions = new ArrayList<Option<Boolean>>();

    public static void createStructuresTab(YetAnotherConfigLib.Builder yacl, StructurifyConfig config) {
        ConfigCategory.Builder structureCategoryBuilder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structures_category.title")).tooltip(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures_category.description")});
        StructuresConfigScreen.addGlobalSettings(structureCategoryBuilder, config);
        StructuresConfigScreen.addStructures(structureCategoryBuilder, config);
        globalDistanceFromWorldCenterOption.addListener((opt, enableGlobalFlatnessCheck) -> {
            for (Option<Boolean> overrideDistanceFromWorldCenterOption : overrideDistanceFromWorldCenterOptions) {
                overrideDistanceFromWorldCenterOption.setAvailable(!globalDistanceFromWorldCenterOption.isPendingValueDefault());
            }
        });
        enableGlobalFlatnessCheckOption.addListener((opt, enableGlobalFlatnessCheck) -> {
            for (int i = 0; i < overrideFlatnessCheckOptions.size(); ++i) {
                Option<Boolean> overrideFlatnessCheckOption = overrideFlatnessCheckOptions.get(i);
                overrideFlatnessCheckOption.setAvailable(enableGlobalFlatnessCheck.booleanValue());
                overrideFlatnessCheckOption.requestSetDefault();
                Option<Boolean> enableFlatnessCheckOption = enableFlatnessCheckOptions.get(i);
                enableFlatnessCheckOption.setAvailable(!overrideFlatnessCheckOption.available());
                enableFlatnessCheckOption.requestSetDefault();
            }
        });
        enableGlobalBiomeCheckOption.addListener((opt, enableGlobalBiomeCheck) -> {
            for (int i = 0; i < overrideBiomeCheckOptions.size(); ++i) {
                Option<Boolean> overrideBiomeCheckOption = overrideBiomeCheckOptions.get(i);
                overrideBiomeCheckOption.setAvailable(enableGlobalBiomeCheck.booleanValue());
                overrideBiomeCheckOption.requestSetDefault();
                Option<Boolean> enableBiomeCheckOption = enableBiomeCheckOptions.get(i);
                enableBiomeCheckOption.setAvailable(!overrideBiomeCheckOption.available());
                enableBiomeCheckOption.requestSetDefault();
            }
        });
        yacl.category(structureCategoryBuilder.build());
    }

    private static void addGlobalSettings(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
        OptionGroup.Builder globalStructuresGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structures.global.title").method_27694(style -> style.method_30938(Boolean.valueOf(true)))).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures.global.description")}));
        globalStructuresGroupBuilder.option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"gui.structurify.structures.structures.structure.title").method_27694(style -> style.method_10982(Boolean.valueOf(true)))));
        Option disableAllStructuresOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structures.disable_all_structures.title")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures.disable_all_structures.description")})).binding((Object)false, () -> config.disableAllStructures, disableAllStructures -> {
            config.disableAllStructures = disableAllStructures;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).formatValue(val -> val != false ? class_2561.method_43471((String)"gui.structurify.label.yes").method_27694(style -> style.method_10977(class_124.field_1061)) : class_2561.method_43471((String)"gui.structurify.label.no").method_27694(style -> style.method_10977(class_124.field_1060)))).build();
        disableAllStructuresOption.addListener((opt, disableAllStructures) -> {
            for (Option<Boolean> structureOption : structureOptions) {
                structureOption.requestSet((Object)(disableAllStructures == false ? 1 : 0));
            }
        });
        globalStructuresGroupBuilder.option(disableAllStructuresOption);
        Option preventStructureOverlapOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structures.prevent_structure_overlap.title")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures.prevent_structure_overlap.description")})).binding((Object)false, () -> config.preventStructureOverlap, preventStructureOverlap -> {
            config.preventStructureOverlap = preventStructureOverlap;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).formatValue(val -> val != false ? class_2561.method_43471((String)"gui.structurify.label.yes").method_27694(style -> style.method_10977(class_124.field_1060)) : class_2561.method_43471((String)"gui.structurify.label.no").method_27694(style -> style.method_10977(class_124.field_1061)))).build();
        globalStructuresGroupBuilder.option(preventStructureOverlapOption);
        Map<String, Option<?>> globalDistanceFromWorldCenterOptions = DistanceFromWorldCenterOptions.addDistanceFromWorldCenterOptions((OptionAddable)globalStructuresGroupBuilder, config, "global");
        globalDistanceFromWorldCenterOption = (HolderOption)globalDistanceFromWorldCenterOptions.get(DistanceFromWorldCenterOptions.DISTANCE_FROM_WORLD_CENTER_OPTION_NAME);
        Map<String, Option<?>> globalFlatnessCheckOptions = FlatnessCheckOptions.addFlatnessCheckOptions((OptionAddable)globalStructuresGroupBuilder, config, "global");
        enableGlobalFlatnessCheckOption = globalFlatnessCheckOptions.get(FlatnessCheckOptions.FLATNESS_CHECK_IS_ENABLED_OPTION_NAME);
        Map<String, Option<?>> globalBiomeCheckOptions = BiomeCheckOptions.addBiomeCheckOptions(globalStructuresGroupBuilder, config, "global");
        OptionGroup blackListedBiomesOption = (OptionGroup)globalBiomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_BLACKLISTED_BIOMES_OPTION_NAME);
        enableGlobalBiomeCheckOption = globalBiomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_IS_ENABLED_OPTION_NAME);
        structureCategoryBuilder.group(globalStructuresGroupBuilder.build());
        structureCategoryBuilder.group(blackListedBiomesOption);
    }

    private static void addStructures(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
        Map<String, StructureData> structures = WorldgenDataProvider.getStructures();
        HashMap structureGroups = new HashMap();
        for (Map.Entry<String, StructureData> entry : structures.entrySet()) {
            String string = entry.getKey();
            class_2960 structureId = Structurify.makeNamespacedId(string);
            String structureNamespace = structureId.method_12836();
            StructureData structureData = entry.getValue();
            if (!structureGroups.containsKey(structureNamespace)) {
                structureGroups.put(structureNamespace, new HashMap());
            }
            ((HashMap)structureGroups.get(structureNamespace)).put(structureId, structureData);
        }
        class_7225.class_7226<class_1959> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        for (Map.Entry entry : structureGroups.entrySet()) {
            String structureNamespace = (String)entry.getKey();
            HashMap namespaceStructures = (HashMap)entry.getValue();
            OptionGroup.Builder invisibleGroup = new InvisibleOptionGroup.Builder().name((class_2561)class_2561.method_43470((String)""));
            invisibleGroup.option((Option)YACLUtil.createEmptyLabelOption());
            structureCategoryBuilder.group(invisibleGroup.build());
            OptionGroup.Builder namespaceGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43469((String)"gui.structurify.structures.structures_group.title", (Object[])new Object[]{LanguageUtil.translateId(null, structureNamespace).getString()}).method_27694(style -> style.method_30938(Boolean.valueOf(true)))).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43469((String)"gui.structurify.structures.structures_group.description", (Object[])new Object[]{structureNamespace})}));
            namespaceGroupBuilder.option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"gui.structurify.structures.structures.structure.title").method_27694(style -> style.method_10982(Boolean.valueOf(true)))));
            for (Map.Entry namespaceStructure : namespaceStructures.entrySet()) {
                StructureData structureData = (StructureData)namespaceStructure.getValue();
                String structureStringId = ((class_2960)namespaceStructure.getKey()).toString();
                Option<Boolean> structureOption = StructuresConfigScreen.addStructure(structureData, structureStringId, biomeRegistry);
                namespaceGroupBuilder.option(structureOption);
                structureOptions.add(structureOption);
            }
            Map<String, Option<?>> namespaceDistanceFromWorldCenterOptions = DistanceFromWorldCenterOptions.addDistanceFromWorldCenterOptions((OptionAddable)namespaceGroupBuilder, config, structureNamespace);
            overrideDistanceFromWorldCenterOptions.add(namespaceDistanceFromWorldCenterOptions.get(DistanceFromWorldCenterOptions.OVERRIDE_GLOBAL_DISTANCE_FROM_WORLD_CENTER_OPTION_NAME));
            OverlapCheckOptions.addOverlapCheckOptions((OptionAddable)namespaceGroupBuilder, config, structureNamespace);
            Map<String, Option<?>> namespaceFlatnessCheckOptions = FlatnessCheckOptions.addFlatnessCheckOptions((OptionAddable)namespaceGroupBuilder, config, structureNamespace);
            overrideFlatnessCheckOptions.add(namespaceFlatnessCheckOptions.get(FlatnessCheckOptions.OVERRIDE_GLOBAL_FLATNESS_CHECK_OPTION_NAME));
            enableFlatnessCheckOptions.add(namespaceFlatnessCheckOptions.get(FlatnessCheckOptions.FLATNESS_CHECK_IS_ENABLED_OPTION_NAME));
            Map<String, Option<?>> namespaceBiomeCheckOptions = BiomeCheckOptions.addBiomeCheckOptions(namespaceGroupBuilder, config, structureNamespace);
            OptionGroup blackListedBiomesOption = (OptionGroup)namespaceBiomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_BLACKLISTED_BIOMES_OPTION_NAME);
            structureCategoryBuilder.group(namespaceGroupBuilder.build());
            structureCategoryBuilder.group(blackListedBiomesOption);
            overrideBiomeCheckOptions.add(namespaceBiomeCheckOptions.get(BiomeCheckOptions.OVERRIDE_GLOBAL_BIOME_CHECK_OPTION_NAME));
            enableBiomeCheckOptions.add(namespaceBiomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_IS_ENABLED_OPTION_NAME));
        }
        OptionGroup.Builder builder = new InvisibleOptionGroup.Builder().name((class_2561)class_2561.method_43470((String)""));
        builder.option((Option)YACLUtil.createEmptyLabelOption());
        structureCategoryBuilder.group(builder.build());
    }

    private static Option<Boolean> addStructure(StructureData structureData, String structureId, class_7225.class_7226<class_1959> biomeRegistry) {
        Option.Builder structureOptionBuilder = Option.createBuilder().name((class_2561)LanguageUtil.translateId("structure", structureId)).binding((Object)true, () -> !structureData.isDisabled(), isEnabled -> structureData.setDisabled(isEnabled == false)).controller(opt -> StructureButtonControllerBuilder.create((Option<Boolean>)opt, structureId).formatValue((ValueFormatter<Boolean>)((ValueFormatter)val -> val != false ? class_2561.method_43471((String)"gui.structurify.label.enabled") : class_2561.method_43471((String)"gui.structurify.label.disabled"))).coloured(true));
        structureOptionBuilder.description(v -> {
            OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();
            descriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures.biomes_description").method_10852((class_2561)class_2561.method_43470((String)"\n"))});
            for (String biome : structureData.getBiomes()) {
                if (biome.contains("#")) {
                    class_6862 biomeTagKey;
                    class_6885.class_6888 biomeTagHolder;
                    if (biomeRegistry == null || (biomeTagHolder = (class_6885.class_6888)biomeRegistry.method_46733(biomeTagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)Structurify.makeNamespacedId(biome.replace("#", "")))).orElse(null)) == null) continue;
                    for (class_6880 biomeHolder : biomeTagHolder.method_40239().toList()) {
                        descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)" - ").method_10852((class_2561)LanguageUtil.translateId("biome", ((class_5321)biomeHolder.method_40229().left().get()).method_29177().method_42094()))});
                    }
                    continue;
                }
                descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)" - ").method_10852((class_2561)LanguageUtil.translateId("biome", biome))});
            }
            descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.structurify.structures.warning")).method_27694(style -> style.method_10977(class_124.field_1054))});
            return descriptionBuilder.build();
        });
        return structureOptionBuilder.build();
    }
}

