/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.data;

import com.faboslav.structurify.common.config.data.StructureLikeData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.common.config.data.structure.DistanceFromWorldCenterCheckData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.common.config.data.structure.JigsawData;
import com.faboslav.structurify.common.config.data.structure.OverlapCheckData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2893;
import net.minecraft.class_5847;

public class StructureData
implements StructureLikeData {
    private final List<String> defaultBiomes;
    private final class_2893.class_2895 defaultStep;
    private final class_5847 defaultTerrainAdaptation;
    private boolean isDisabled = false;
    private List<String> biomes;
    private class_2893.class_2895 step;
    private class_5847 terrainAdaptation;
    private JigsawData jigsawData;
    private DistanceFromWorldCenterCheckData distanceFromWorldCenterCheckData;
    private OverlapCheckData overlapCheckData;
    private FlatnessCheckData flatnessCheckData;
    private BiomeCheckData biomeCheckData;

    public StructureData(List<String> biomes, class_2893.class_2895 step, class_5847 terrainAdaptation) {
        this.defaultBiomes = biomes;
        this.biomes = biomes;
        this.defaultStep = step;
        this.step = step;
        this.defaultTerrainAdaptation = terrainAdaptation;
        this.terrainAdaptation = terrainAdaptation;
        this.jigsawData = new JigsawData(0, 0, 0);
        this.distanceFromWorldCenterCheckData = new DistanceFromWorldCenterCheckData();
        this.overlapCheckData = new OverlapCheckData();
        this.flatnessCheckData = new FlatnessCheckData();
        this.biomeCheckData = new BiomeCheckData();
    }

    public boolean isUsingDefaultValues() {
        ArrayList<String> biomes = new ArrayList<String>(this.biomes);
        ArrayList<String> defaultBiomes = new ArrayList<String>(this.defaultBiomes);
        Collections.sort(biomes);
        Collections.sort(defaultBiomes);
        return !this.isDisabled && this.step == this.defaultStep && this.terrainAdaptation == this.defaultTerrainAdaptation && biomes.equals(defaultBiomes) && (!this.isJigsawStructure() || this.isJigsawStructure() && this.getJigsawData().isUsingDefaultValues()) && this.getDistanceFromWorldCenterCheckData().isUsingDefaultValues() && this.getOverlapCheckData().isUsingDefaultValues() && this.getFlatnessCheckData().isUsingDefaultValues() && this.getBiomeCheckData().isUsingDefaultValues();
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public List<String> getDefaultBiomes() {
        return this.defaultBiomes;
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public void setBiomes(List<String> biomes) {
        this.biomes = biomes;
    }

    public class_2893.class_2895 getDefaultStep() {
        return this.defaultStep;
    }

    public class_2893.class_2895 getStep() {
        return this.step;
    }

    public void setStep(class_2893.class_2895 step) {
        this.step = step;
    }

    public class_5847 getDefaultTerrainAdaptation() {
        return this.defaultTerrainAdaptation;
    }

    public class_5847 getTerrainAdaptation() {
        return this.terrainAdaptation;
    }

    public void setTerrainAdaptation(class_5847 terrainAdaptation) {
        this.terrainAdaptation = terrainAdaptation;
    }

    public boolean isJigsawStructure() {
        return this.jigsawData.getSize() != 0 && this.jigsawData.getHorizontalMaxDistanceFromCenter() != 0 && this.jigsawData.getVerticalMaxDistanceFromCenter() != 0;
    }

    public JigsawData getJigsawData() {
        return this.jigsawData;
    }

    public void setJigsawData(JigsawData jigsawData) {
        this.jigsawData = jigsawData;
    }

    @Override
    public DistanceFromWorldCenterCheckData getDistanceFromWorldCenterCheckData() {
        return this.distanceFromWorldCenterCheckData;
    }

    @Override
    public void setDistanceFromWorldCenterCheckData(DistanceFromWorldCenterCheckData distanceFromWorldCenterCheckData) {
        this.distanceFromWorldCenterCheckData = distanceFromWorldCenterCheckData;
    }

    @Override
    public OverlapCheckData getOverlapCheckData() {
        return this.overlapCheckData;
    }

    @Override
    public void setOverlapCheckData(OverlapCheckData overlapCheckData) {
        this.overlapCheckData = overlapCheckData;
    }

    @Override
    public FlatnessCheckData getFlatnessCheckData() {
        return this.flatnessCheckData;
    }

    @Override
    public void setFlatnessCheckData(FlatnessCheckData flatnessCheckData) {
        this.flatnessCheckData = flatnessCheckData;
    }

    @Override
    public BiomeCheckData getBiomeCheckData() {
        return this.biomeCheckData;
    }

    @Override
    public void setBiomeCheckData(BiomeCheckData biomeCheckData) {
        this.biomeCheckData = biomeCheckData;
    }
}

