/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckSample;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_5539;
import net.minecraft.class_7138;
import org.jetbrains.annotations.Nullable;

public final class StructureFlatnessCheck {
    @Nullable
    public static FlatnessCheckData getFlatnessCheckData(StructureCheckData structureCheckData) {
        FlatnessCheckData structureFlatnessCheckData;
        FlatnessCheckData namespaceFlatnessCheckData;
        StructurifyStructure structure = structureCheckData.getStructure();
        class_2960 structureId = structureCheckData.getStructureId();
        StructureNamespaceData globalNamespaceData = structure.structurify$getGlobalStructureNamespaceData();
        StructureNamespaceData structureNamespaceData = structure.structurify$getStructureNamespaceData(structureId);
        StructureData structureData = structure.structurify$getStructureData(structureId);
        FlatnessCheckData flatnessCheckDataToCheck = null;
        if (globalNamespaceData != null) {
            flatnessCheckDataToCheck = globalNamespaceData.getFlatnessCheckData();
        }
        if (structureNamespaceData != null && ((namespaceFlatnessCheckData = structureNamespaceData.getFlatnessCheckData()).isOverridingGlobalFlatnessCheck() || namespaceFlatnessCheckData.isEnabled())) {
            flatnessCheckDataToCheck = namespaceFlatnessCheckData;
        }
        if (structureData != null && ((structureFlatnessCheckData = structureData.getFlatnessCheckData()).isOverridingGlobalFlatnessCheck() || structureFlatnessCheckData.isEnabled())) {
            flatnessCheckDataToCheck = structureFlatnessCheckData;
        }
        return flatnessCheckDataToCheck;
    }

    public static boolean canDoFlatnessCheck(StructureCheckData structureCheckData, @Nullable FlatnessCheckData flatnessCheckData) {
        StructurifyStructure structure = structureCheckData.getStructure();
        if (flatnessCheckData == null || !flatnessCheckData.isEnabled()) {
            return false;
        }
        StructureData structureData = structure.structurify$getStructureData();
        return structureData != null;
    }

    public static boolean checkFlatness(StructureCheckData structureCheckData, FlatnessCheckData flatnessCheckData, class_2794 chunkGenerator, class_5539 heightAccessor, class_7138 randomState) {
        List<class_3443> structurePieces = structureCheckData.getStructurePieces();
        int[][] structurePieceSamples = structureCheckData.getStructurePieceSamples();
        class_2960 structureId = structureCheckData.getStructureId();
        class_3449 structureStart = structureCheckData.getStructureStart();
        class_2338 structureCenter = structureCheckData.getStructureCenter();
        HashSet<StructureFlatnessCheckSample> flatnessCheckSamples = new HashSet<StructureFlatnessCheckSample>();
        int structureArea = 0;
        for (class_3443 structurePiece : structurePieces) {
            class_3341 structurePieceBoundingBox = structurePiece.method_14935();
            int spanX = structurePieceBoundingBox.method_35414();
            int spanZ = structurePieceBoundingBox.method_14663();
            structureArea += spanX * spanZ;
        }
        int flatnessCheckHeightThreshold = class_3532.method_15340((int)((int)Math.round(Math.sqrt(structureArea) * 0.33)), (int)3, (int)21);
        int totalFlatnessChecks = structurePieceSamples.length;
        int nonSolidFlatnessChecks = 0;
        int nonSolidFlatnessChecksThreshold = Math.max(1, (int)Math.floor((double)totalFlatnessChecks * 0.33 * Math.pow(Math.min(1.0, (double)totalFlatnessChecks / 100.0), 0.33)));
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        for (int currentFlatnessCheck = 0; currentFlatnessCheck < totalFlatnessChecks; ++currentFlatnessCheck) {
            int x = structurePieceSamples[currentFlatnessCheck][0];
            int z = structurePieceSamples[currentFlatnessCheck][1];
            int firstOceanFloorOccupiedHeight = chunkGenerator.method_18028(x, z, class_2902.class_2903.field_13195, heightAccessor, randomState);
            if (firstOceanFloorOccupiedHeight > maxHeight && (maxHeight = firstOceanFloorOccupiedHeight) - minHeight > flatnessCheckHeightThreshold) {
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(class_1923.method_37232((class_2338)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.method_14969(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            if (firstOceanFloorOccupiedHeight < minHeight && maxHeight - (minHeight = firstOceanFloorOccupiedHeight) > flatnessCheckHeightThreshold) {
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(class_1923.method_37232((class_2338)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.method_14969(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            if (!flatnessCheckData.areNonSolidBlocksAllowed()) {
                boolean isSolid;
                int remainingFlatnessChecks = totalFlatnessChecks - currentFlatnessCheck;
                if (nonSolidFlatnessChecks + remainingFlatnessChecks < nonSolidFlatnessChecksThreshold && !Structurify.getConfig().getDebugData().isEnabled()) continue;
                int firstWorldSurfaceFreeHeight = chunkGenerator.method_20402(x, z, class_2902.class_2903.field_13194, heightAccessor, randomState);
                boolean bl = isSolid = firstWorldSurfaceFreeHeight - firstOceanFloorOccupiedHeight == 1;
                if (Structurify.getConfig().getDebugData().isEnabled()) {
                    flatnessCheckSamples.add(new StructureFlatnessCheckSample(structureId, x, z, firstOceanFloorOccupiedHeight, firstWorldSurfaceFreeHeight, isSolid));
                }
                if (isSolid || ++nonSolidFlatnessChecks < nonSolidFlatnessChecksThreshold) continue;
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(class_1923.method_37232((class_2338)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.method_14969(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            flatnessCheckSamples.add(new StructureFlatnessCheckSample(structureId, x, z, firstOceanFloorOccupiedHeight, firstOceanFloorOccupiedHeight, true));
        }
        flatnessCheckSamples.forEach(flatnessCheckSample -> Structurify.getConfig().getDebugData().addStructureFlatnessCheckSample(class_1923.method_37232((class_2338)structureCenter), (StructureFlatnessCheckSample)flatnessCheckSample));
        Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(class_1923.method_37232((class_2338)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.method_14969(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, true));
        return true;
    }

    private StructureFlatnessCheck() {
    }
}

