/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.structure.OverlapCheckData;
import com.faboslav.structurify.world.level.structure.StructureSectionClaim;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public final class StructureOverlapCheck {
    @Nullable
    public static OverlapCheckData getOverlapCheckData(StructureCheckData structureCheckData) {
        OverlapCheckData structureOverlapCheckData;
        OverlapCheckData namespaceOverlapCheckData;
        StructurifyStructure structure = structureCheckData.getStructure();
        class_2960 structureId = structureCheckData.getStructureId();
        StructureNamespaceData structureNamespaceData = structure.structurify$getStructureNamespaceData(structureId);
        StructureData structureData = structure.structurify$getStructureData(structureId);
        OverlapCheckData overlapCheckDataToCheck = null;
        if (structureNamespaceData != null && (namespaceOverlapCheckData = structureNamespaceData.getOverlapCheckData()).isExcludedFromOverlapPrevention()) {
            overlapCheckDataToCheck = namespaceOverlapCheckData;
        }
        if (structureData != null && (structureOverlapCheckData = structureData.getOverlapCheckData()).isExcludedFromOverlapPrevention()) {
            overlapCheckDataToCheck = structureOverlapCheckData;
        }
        return overlapCheckDataToCheck;
    }

    public static boolean canDoOverlapCheck(StructureCheckData structureCheckData, @Nullable OverlapCheckData overlapCheckData) {
        if (!Structurify.getConfig().preventStructureOverlap) {
            return false;
        }
        StructureData structureData = structureCheckData.getStructure().structurify$getStructureData();
        if (structureData == null) {
            return false;
        }
        return overlapCheckData == null || !overlapCheckData.isExcludedFromOverlapPrevention();
    }

    public static boolean checkForOverlap(StructureCheckData structureCheckData, OverlapCheckData overlapCheckData, StructurifyChunkGenerator structurifyChunkGenerator) {
        class_3449 start = structureCheckData.getStructureStart();
        long[] structureCells = StructureOverlapCheck.getStructurePiecesSections(start);
        long structureCenter = start.method_14969().method_22874().method_10063();
        boolean overlapCheckResult = !StructureOverlapCheck.claimStructureSections(structurifyChunkGenerator, structureCells, structureCheckData.getStructureId(), structureCenter);
        return overlapCheckResult;
    }

    private static long[] getStructurePiecesSections(class_3449 start) {
        HashSet<Long> structurePieceSectionUniqueKeys = new HashSet<Long>();
        for (class_3443 piece : start.method_14963()) {
            class_3341 b = piece.method_14935();
            int minSx = class_4076.method_18675((int)b.method_35415());
            int maxSx = class_4076.method_18675((int)b.method_35418());
            int minSz = class_4076.method_18675((int)b.method_35417());
            int maxSz = class_4076.method_18675((int)b.method_35420());
            int minSy = class_4076.method_18675((int)b.method_35416());
            int maxSy = class_4076.method_18675((int)b.method_35419());
            for (int sz = minSz; sz <= maxSz; ++sz) {
                for (int sx = minSx; sx <= maxSx; ++sx) {
                    for (int sy = minSy; sy <= maxSy; ++sy) {
                        structurePieceSectionUniqueKeys.add(class_4076.method_18685((int)sx, (int)sy, (int)sz));
                    }
                }
            }
        }
        long[] structurePieceSectionKeys = new long[structurePieceSectionUniqueKeys.size()];
        int i = 0;
        for (Long structurePieceSectionKey : structurePieceSectionUniqueKeys) {
            structurePieceSectionKeys[i++] = structurePieceSectionKey;
        }
        return structurePieceSectionKeys;
    }

    private static boolean claimStructureSections(StructurifyChunkGenerator gen, long[] sectionKeysToClaim, class_2960 structureId, long structureCenter) {
        long token = ThreadLocalRandom.current().nextLong();
        StructureSectionClaim claim = new StructureSectionClaim(token, structureId.toString(), structureCenter);
        long[] claimed = new long[sectionKeysToClaim.length];
        for (int acquired = 0; acquired < sectionKeysToClaim.length; ++acquired) {
            long key;
            claimed[acquired] = key = sectionKeysToClaim[acquired];
            StructureSectionClaim prev = gen.structurify$getStructureSectionClaims().putIfAbsent(key, claim);
            if (prev == null || structureId.toString().equals(prev.structureId()) && structureCenter == prev.structureCenter()) continue;
            for (int i = 0; i < acquired; ++i) {
                gen.structurify$getStructureSectionClaims().remove(claimed[i], claim);
            }
            return false;
        }
        return true;
    }
}

