/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.serialization;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.common.config.data.structure.DistanceFromWorldCenterCheckData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.common.config.data.structure.JigsawData;
import com.faboslav.structurify.common.config.serialization.BiomeCheckDataSerializer;
import com.faboslav.structurify.common.config.serialization.DistanceFromWorldCenterDataSerializer;
import com.faboslav.structurify.common.config.serialization.FlatnessCheckDataSerializer;
import com.faboslav.structurify.common.config.serialization.JigsawDataSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public final class StructureDataSerializer {
    public static final String NAME_PROPERTY = "name";
    private static final String IS_DISABLED_PROPERTY = "is_disabled";
    private static final String BIOMES_PROPERTY = "biomes";
    private static final String WHITELISTED_BIOMES_PROPERTY = "whitelisted_biomes";
    private static final String BLACKLISTED_BIOMES_PROPERTY = "blacklisted_biomes";
    public static final String STEP_PROPERTY = "step";
    public static final String TERRAIN_ADAPTATION_PROPERTY = "terrain_adaptation";

    public static void load(JsonObject structureJson, StructureData structureData) {
        String structureName = structureJson.get(NAME_PROPERTY).getAsString();
        if (structureJson.has(IS_DISABLED_PROPERTY)) {
            structureData.setDisabled(structureJson.get(IS_DISABLED_PROPERTY).getAsBoolean());
        }
        ArrayList<String> biomes = new ArrayList<String>(structureData.getDefaultBiomes());
        if (structureJson.has(BIOMES_PROPERTY)) {
            whitelistedBiomes = structureJson.getAsJsonArray(BIOMES_PROPERTY).asList().stream().map(JsonElement::getAsString).collect(Collectors.toCollection(ArrayList::new));
            whitelistedBiomes.removeAll(structureData.getDefaultBiomes());
            whitelistedBiomes.stream().distinct().forEach(biomes::add);
            blacklistedBiomes = new ArrayList<String>(structureData.getDefaultBiomes());
            ((ArrayList)blacklistedBiomes).removeAll(structureJson.getAsJsonArray(BIOMES_PROPERTY).asList().stream().map(JsonElement::getAsString).collect(Collectors.toCollection(ArrayList::new)));
            blacklistedBiomes.stream().distinct().forEach(biomes::remove);
        } else if (structureJson.has(WHITELISTED_BIOMES_PROPERTY) && structureJson.has(BLACKLISTED_BIOMES_PROPERTY)) {
            whitelistedBiomes = structureJson.getAsJsonArray(WHITELISTED_BIOMES_PROPERTY);
            for (JsonElement whitelistedBiome : whitelistedBiomes) {
                if (biomes.contains(whitelistedBiome.getAsString())) continue;
                biomes.add(whitelistedBiome.getAsString());
            }
            blacklistedBiomes = structureJson.getAsJsonArray(BLACKLISTED_BIOMES_PROPERTY);
            Iterator iterator = blacklistedBiomes.iterator();
            while (iterator.hasNext()) {
                JsonElement blacklistedBiome = (JsonElement)iterator.next();
                if (!biomes.contains(blacklistedBiome.getAsString())) continue;
                biomes.remove(blacklistedBiome.getAsString());
            }
        }
        structureData.setBiomes(biomes);
        if (structureJson.has(STEP_PROPERTY)) {
            String rawStep = structureJson.get(STEP_PROPERTY).getAsString();
            GenerationStep.Decoration step = Arrays.stream(GenerationStep.Decoration.values()).filter(s -> s.m_7912_().equals(rawStep)).findFirst().orElseGet(() -> {
                Structurify.getLogger().info("Step value for structure {} is currently '{}', which is invalid. Value will be corrected to {}.", new Object[]{structureName, rawStep, structureData.getDefaultStep().m_7912_()});
                return structureData.getDefaultStep();
            });
            structureData.setStep(step);
        }
        if (structureJson.has(TERRAIN_ADAPTATION_PROPERTY)) {
            String rawTerrainAdaptation = structureJson.get(TERRAIN_ADAPTATION_PROPERTY).getAsString();
            TerrainAdjustment terrainAdaptation = Arrays.stream(TerrainAdjustment.values()).filter(s -> s.m_7912_().equals(rawTerrainAdaptation)).findFirst().orElseGet(() -> {
                Structurify.getLogger().info("Terrain adaptation value for structure {} is currently '{}', which is invalid. Value will be corrected to {}.", new Object[]{structureName, rawTerrainAdaptation, structureData.getDefaultTerrainAdaptation().m_7912_()});
                return structureData.getDefaultTerrainAdaptation();
            });
            structureData.setTerrainAdaptation(terrainAdaptation);
        }
        if (structureData.isJigsawStructure()) {
            JigsawDataSerializer.load(structureJson, structureData.getJigsawData());
        }
        FlatnessCheckDataSerializer.load(structureJson, structureData.getFlatnessCheckData());
        BiomeCheckDataSerializer.load(structureJson, structureData.getBiomeCheckData());
    }

    public static void save(JsonArray structuresJson, String structureName, StructureData structureData) {
        BiomeCheckData biomeCheckData;
        FlatnessCheckData flatnessCheckData;
        DistanceFromWorldCenterCheckData distanceFromWorldCenterData;
        JigsawData jigsawData;
        JsonObject structure = new JsonObject();
        structure.addProperty(NAME_PROPERTY, structureName);
        structure.addProperty(IS_DISABLED_PROPERTY, Boolean.valueOf(structureData.isDisabled()));
        ArrayList<String> whitelistedBiomes = new ArrayList<String>(structureData.getBiomes());
        whitelistedBiomes.removeAll(structureData.getDefaultBiomes());
        JsonArray whitelistedBiomesJson = new JsonArray();
        whitelistedBiomes.stream().distinct().forEach(arg_0 -> ((JsonArray)whitelistedBiomesJson).add(arg_0));
        structure.add(WHITELISTED_BIOMES_PROPERTY, (JsonElement)whitelistedBiomesJson);
        ArrayList<String> blacklistedBiomes = new ArrayList<String>(structureData.getDefaultBiomes());
        blacklistedBiomes.removeAll(structureData.getBiomes());
        JsonArray blacklistedBiomesJson = new JsonArray();
        blacklistedBiomes.stream().distinct().forEach(arg_0 -> ((JsonArray)blacklistedBiomesJson).add(arg_0));
        structure.add(BLACKLISTED_BIOMES_PROPERTY, (JsonElement)blacklistedBiomesJson);
        structure.addProperty(STEP_PROPERTY, structureData.getStep().m_7912_());
        structure.addProperty(TERRAIN_ADAPTATION_PROPERTY, structureData.getTerrainAdaptation().m_7912_());
        if (structureData.isJigsawStructure() && !(jigsawData = structureData.getJigsawData()).isUsingDefaultValues()) {
            JigsawDataSerializer.save(structure, jigsawData);
        }
        if (!(distanceFromWorldCenterData = structureData.getDistanceFromWorldCenterCheckData()).isUsingDefaultValues()) {
            DistanceFromWorldCenterDataSerializer.save(structure, distanceFromWorldCenterData);
        }
        if (!(flatnessCheckData = structureData.getFlatnessCheckData()).isUsingDefaultValues()) {
            FlatnessCheckDataSerializer.save(structure, flatnessCheckData);
        }
        if (!(biomeCheckData = structureData.getBiomeCheckData()).isUsingDefaultValues()) {
            BiomeCheckDataSerializer.save(structure, biomeCheckData);
        }
        structuresJson.add((JsonElement)structure);
    }
}

