/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckSample;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public final class StructureFlatnessCheck {
    public static FlatnessCheckData getFlatnessCheckData(StructurifyStructure structure) {
        FlatnessCheckData globalFlatnessCheckData = structure.structurify$getGlobalStructureNamespaceData().getFlatnessCheckData();
        FlatnessCheckData namespaceFlatnessCheckData = structure.structurify$getStructureNamespaceData().getFlatnessCheckData();
        FlatnessCheckData structureFlatnessCheckData = structure.structurify$getStructureData().getFlatnessCheckData();
        FlatnessCheckData flatnessCheckDataToCheck = globalFlatnessCheckData;
        if (namespaceFlatnessCheckData.isOverridingGlobalFlatnessCheck() || namespaceFlatnessCheckData.isEnabled()) {
            flatnessCheckDataToCheck = namespaceFlatnessCheckData;
        }
        if (structureFlatnessCheckData.isOverridingGlobalFlatnessCheck() || structureFlatnessCheckData.isEnabled()) {
            flatnessCheckDataToCheck = structureFlatnessCheckData;
        }
        return flatnessCheckDataToCheck;
    }

    public static boolean checkFlatness(StructureCheckData structureCheckData, FlatnessCheckData flatnessCheckData, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState) {
        List<StructurePiece> structurePieces = structureCheckData.getStructurePieces();
        int[][] structurePieceSamples = structureCheckData.getStructurePieceSamples();
        ResourceLocation structureId = structureCheckData.getStructureId();
        StructureStart structureStart = structureCheckData.getStructureStart();
        BlockPos structureCenter = structureCheckData.getStructureCenter();
        HashSet<StructureFlatnessCheckSample> flatnessCheckSamples = new HashSet<StructureFlatnessCheckSample>();
        int structureArea = 0;
        for (StructurePiece structurePiece : structurePieces) {
            BoundingBox structurePieceBoundingBox = structurePiece.m_73547_();
            int spanX = structurePieceBoundingBox.m_71056_();
            int spanZ = structurePieceBoundingBox.m_71058_();
            structureArea += spanX * spanZ;
        }
        int flatnessCheckHeightThreshold = Mth.m_14045_((int)((int)Math.round(Math.sqrt(structureArea) * 0.25)), (int)2, (int)20);
        int totalFlatnessChecks = structurePieceSamples.length;
        int nonSolidFlatnessChecks = 0;
        int nonSolidFlatnessChecksThreshold = Math.max(1, (int)Math.floor((double)totalFlatnessChecks * 0.33 * Math.pow(Math.min(1.0, (double)totalFlatnessChecks / 100.0), 0.33)));
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        for (int currentFlatnessCheck = 0; currentFlatnessCheck < totalFlatnessChecks; ++currentFlatnessCheck) {
            int x = structurePieceSamples[currentFlatnessCheck][0];
            int z = structurePieceSamples[currentFlatnessCheck][1];
            int firstOceanFloorOccupiedHeight = chunkGenerator.m_223235_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, heightAccessor, randomState);
            if (firstOceanFloorOccupiedHeight > maxHeight && (maxHeight = firstOceanFloorOccupiedHeight) - minHeight > flatnessCheckHeightThreshold) {
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(ChunkPos.m_151388_((BlockPos)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.m_73601_(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            if (firstOceanFloorOccupiedHeight < minHeight && maxHeight - (minHeight = firstOceanFloorOccupiedHeight) > flatnessCheckHeightThreshold) {
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(ChunkPos.m_151388_((BlockPos)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.m_73601_(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            if (!flatnessCheckData.areNonSolidBlocksAllowed()) {
                boolean isSolid;
                int remainingFlatnessChecks = totalFlatnessChecks - currentFlatnessCheck;
                if (nonSolidFlatnessChecks + remainingFlatnessChecks < nonSolidFlatnessChecksThreshold && !Structurify.getConfig().getDebugData().isEnabled()) continue;
                int firstWorldSurfaceFreeHeight = chunkGenerator.m_223221_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState);
                boolean bl = isSolid = firstWorldSurfaceFreeHeight - firstOceanFloorOccupiedHeight == 1;
                if (Structurify.getConfig().getDebugData().isEnabled()) {
                    flatnessCheckSamples.add(new StructureFlatnessCheckSample(structureId, x, z, firstOceanFloorOccupiedHeight, firstWorldSurfaceFreeHeight, isSolid));
                }
                if (isSolid || ++nonSolidFlatnessChecks < nonSolidFlatnessChecksThreshold) continue;
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(ChunkPos.m_151388_((BlockPos)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.m_73601_(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            flatnessCheckSamples.add(new StructureFlatnessCheckSample(structureId, x, z, firstOceanFloorOccupiedHeight, firstOceanFloorOccupiedHeight, true));
        }
        flatnessCheckSamples.forEach(flatnessCheckSample -> Structurify.getConfig().getDebugData().addStructureFlatnessCheckSample(ChunkPos.m_151388_((BlockPos)structureCenter), (StructureFlatnessCheckSample)flatnessCheckSample));
        Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(ChunkPos.m_151388_((BlockPos)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.m_73601_(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, true));
        return true;
    }

    private StructureFlatnessCheck() {
    }
}

