/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.debug;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.DebugData;
import com.faboslav.structurify.common.mixin.structure.pools.SinglePoolElementAccessor;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckSample;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckSample;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3790;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9974;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public final class StructurifyDebugRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(class_310 minecraft, class_4587 poseStack, @Nullable class_4597 bufferSource) {
        DebugData debugData = Structurify.getConfig().getDebugData();
        if (!debugData.isEnabled()) {
            return;
        }
        DebugData.DebugMode debugMode = debugData.getDebugMode();
        if (bufferSource == null) {
            bufferSource = minecraft.method_22940().method_23000();
        }
        int viewDistance = minecraft.method_1576().method_3760().method_14568();
        int chunkRadius = Math.max(1, viewDistance);
        class_4184 camera = minecraft.field_1773.method_19418();
        class_243 cameraPosition = camera.method_19326();
        class_2338 cameraBlockPosition = class_2338.method_49638((class_2374)cameraPosition);
        double camX = cameraPosition.field_1352;
        double camY = cameraPosition.field_1351;
        double camZ = cameraPosition.field_1350;
        if (debugMode == DebugData.DebugMode.FLATNESS) {
            Map<Long, StructureFlatnessCheckOverview> structureFlatnessCheckOverviews;
            Map<Long, StructureFlatnessCheckOverview> map = structureFlatnessCheckOverviews = Structurify.getConfig().getDebugData().getStructureFlatnessCheckOverviews();
            synchronized (map) {
                for (StructureFlatnessCheckOverview structureFlatnessCheckOverview : structureFlatnessCheckOverviews.values().stream().filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.structureBoundingBox().method_22874(), chunkRadius)).toList()) {
                    this.renderStructureFlatnessCheckOverview(structureFlatnessCheckOverview, minecraft, poseStack, bufferSource, camX, camY, camZ);
                }
            }
            Map<Long, Set<StructureFlatnessCheckSample>> structureFlatnessCheckSamples = Structurify.getConfig().getDebugData().getStructureFlatnessCheckSamples();
            Map<Long, Set<StructureFlatnessCheckSample>> map2 = structureFlatnessCheckSamples;
            synchronized (map2) {
                for (StructureFlatnessCheckSample structureFlatnessCheckSample : structureFlatnessCheckSamples.values().stream().flatMap(Collection::stream).filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.x(), o.freeY(), o.z(), chunkRadius)).toList()) {
                    this.renderStructureFlatnessCheckSample(structureFlatnessCheckSample, poseStack, bufferSource, camX, camY, camZ);
                }
            }
        }
        if (debugMode == DebugData.DebugMode.BIOME) {
            Map<Long, StructureBiomeCheckOverview> structureBiomeCheckOverviews;
            Map<Long, StructureBiomeCheckOverview> structureFlatnessCheckSamples = structureBiomeCheckOverviews = Structurify.getConfig().getDebugData().getStructureBiomeCheckOverviews();
            synchronized (structureFlatnessCheckSamples) {
                for (StructureBiomeCheckOverview structureBiomeCheckOverview : structureBiomeCheckOverviews.values().stream().filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.structureBoundingBox().method_22874(), chunkRadius)).toList()) {
                    this.renderStructureBiomeCheckOverview(structureBiomeCheckOverview, minecraft, poseStack, bufferSource, camX, camY, camZ);
                }
            }
            Map<Long, Set<StructureBiomeCheckSample>> structureBiomeCheckSamples = Structurify.getConfig().getDebugData().getStructureBiomeCheckSamples();
            Map<Long, Set<StructureBiomeCheckSample>> map = structureBiomeCheckSamples;
            synchronized (map) {
                for (StructureBiomeCheckSample structureBiomeCheckSample : structureBiomeCheckSamples.values().stream().flatMap(Collection::stream).filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.x(), o.y(), o.z(), chunkRadius)).toList()) {
                    this.renderStructureBiomeCheckSample(structureBiomeCheckSample, poseStack, bufferSource, camX, camY, camZ);
                }
            }
        }
    }

    private void renderStructureFlatnessCheckOverview(StructureFlatnessCheckOverview structureFlatnessCheckOverview, class_310 minecraft, class_4587 poseStack, class_4597 bufferSource, double camX, double camY, double camZ) {
        class_3341 structureBoundingBox = structureFlatnessCheckOverview.structureBoundingBox();
        StructurifyDebugRenderer.renderBoundingBox(structureBoundingBox, poseStack, bufferSource.method_73477(class_1921.method_23594()), camX, camY, camZ, 0.8f);
        this.renderLabel(structureBoundingBox, structureFlatnessCheckOverview.toString(), minecraft, poseStack, bufferSource, camX, camY, camZ);
        this.renderStructurePiecesForOverview(structureBoundingBox, structureFlatnessCheckOverview.structurePieces(), minecraft, poseStack, bufferSource, camX, camY, camZ);
    }

    private void renderStructureBiomeCheckOverview(StructureBiomeCheckOverview structureBiomeCheckOverview, class_310 minecraft, class_4587 poseStack, class_4597 bufferSource, double camX, double camY, double camZ) {
        class_3341 structureBoundingBox = structureBiomeCheckOverview.structureBoundingBox();
        StructurifyDebugRenderer.renderBoundingBox(structureBoundingBox, poseStack, bufferSource.method_73477(class_1921.method_23594()), camX, camY, camZ, 0.8f);
        this.renderLabel(structureBoundingBox, structureBiomeCheckOverview.toString(), minecraft, poseStack, bufferSource, camX, camY, camZ);
        this.renderStructurePiecesForOverview(structureBoundingBox, structureBiomeCheckOverview.structurePieces(), minecraft, poseStack, bufferSource, camX, camY, camZ);
    }

    private void renderStructurePiecesForOverview(class_3341 structureBoundingBox, List<class_3443> structurePieces, class_310 minecraft, class_4587 poseStack, class_4597 bufferSource, double camX, double camY, double camZ) {
        for (class_3443 structurePiece : structurePieces) {
            class_3341 structurePieceBoundingBox = structurePiece.method_14935();
            if (structurePieceBoundingBox.equals((Object)structureBoundingBox)) continue;
            StructurifyDebugRenderer.renderBoundingBox(structurePieceBoundingBox, poseStack, bufferSource.method_73477(class_1921.method_23594()), camX, camY, camZ, 0.2f);
            String pieceName = "";
            if (structurePiece instanceof class_3790) {
                class_3790 poolPiece = (class_3790)structurePiece;
                class_3784 element = poolPiece.method_16644();
                if (element instanceof class_3781) {
                    class_3781 single = (class_3781)element;
                    class_2960 template = ((SinglePoolElementAccessor)single).getTemplate().left().orElse(null);
                    if (template != null) {
                        pieceName = template.toString();
                    }
                } else {
                    pieceName = "";
                }
            }
            this.renderLabel(structurePieceBoundingBox, pieceName, minecraft, poseStack, bufferSource, camX, camY, camZ);
        }
    }

    private void renderStructureFlatnessCheckSample(StructureFlatnessCheckSample structureFlatnessCheckSample, class_4587 poseStack, class_4597 bufferSource, double camX, double camY, double camZ) {
        int x = structureFlatnessCheckSample.x();
        int z = structureFlatnessCheckSample.z();
        int occY = structureFlatnessCheckSample.occY();
        int freeY = Math.max(structureFlatnessCheckSample.freeY(), occY + 1);
        boolean solid = structureFlatnessCheckSample.isSolid();
        float r = solid ? 0.2f : 1.0f;
        float g = solid ? 1.0f : 0.2f;
        float b = 0.2f;
        float a = 0.95f;
        class_238 col = new class_238((double)x, (double)occY, (double)z, (double)(x + 1), (double)freeY, (double)(z + 1)).method_989(-camX, -camY, -camZ);
        StructurifyDebugRenderer.renderLineBox(poseStack, bufferSource.method_73477(class_1921.method_23594()), col, r, g, 0.2f, 0.95f);
    }

    private void renderStructureBiomeCheckSample(StructureBiomeCheckSample structureBiomeCheckSample, class_4587 poseStack, class_4597 bufferSource, double camX, double camY, double camZ) {
        int x = structureBiomeCheckSample.x();
        int y = structureBiomeCheckSample.y();
        int z = structureBiomeCheckSample.z();
        boolean result = structureBiomeCheckSample.result();
        float r = result ? 0.2f : 1.0f;
        float g = result ? 1.0f : 0.2f;
        float b = 0.2f;
        float a = 0.95f;
        class_238 col = new class_238((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).method_989(-camX, -camY, -camZ);
    }

    private static void renderBoundingBox(class_3341 boundingBox, class_4587 poseStack, class_4588 vertexConsumer, double cameraX, double cameraY, double cameraZ, float alpha) {
        class_238 aabb = new class_238((double)boundingBox.method_35415(), (double)boundingBox.method_35416(), (double)boundingBox.method_35417(), (double)(boundingBox.method_35418() + 1), (double)(boundingBox.method_35419() + 1), (double)(boundingBox.method_35420() + 1)).method_989(-cameraX, -cameraY, -cameraZ);
        StructurifyDebugRenderer.renderLineBox(poseStack, vertexConsumer, aabb, 1.0f, 1.0f, 1.0f, alpha);
    }

    public static void renderLineBox(class_4587 poseStack, class_4588 buffer, class_238 box, float red, float green, float blue, float alpha) {
        class_9974.method_62295((class_4587.class_4665)poseStack.method_23760(), (class_4588)buffer, (class_238)box, (float)red, (float)green, (float)blue, (float)alpha);
    }

    private void renderLabel(class_3341 box, String label, class_310 mc, class_4587 poseStack, class_4597 buffers, double camX, double camY, double camZ) {
        double centerX = (double)(box.method_35415() + box.method_35418() + 1) * 0.5;
        double centerZ = (double)(box.method_35417() + box.method_35420() + 1) * 0.5;
        double topY = (double)box.method_35419() + 1.0;
        double labelY = topY + 0.25;
        poseStack.method_22903();
        poseStack.method_22904(centerX - camX, labelY - camY, centerZ - camZ);
        poseStack.method_22907((Quaternionfc)mc.field_1773.method_19418().method_23767());
        float spanX = box.method_35414();
        float spanZ = box.method_14663();
        float diagXZ = (float)Math.sqrt(spanX * spanX + spanZ * spanZ);
        float dynamicScaleFactor = Math.max(1.0f, diagXZ / 24.0f);
        float base = 0.025f;
        float scale = base * dynamicScaleFactor;
        poseStack.method_22905(-scale, -scale, scale);
        class_327 font = mc.field_1772;
        String[] lines = label.split("\n");
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int totalPixelHeight = lines.length * lineHeight;
        float yStart = -totalPixelHeight;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int width = font.method_1727(line);
            font.method_27521(line, (float)(-width) / 2.0f, yStart + (float)(i * lineHeight), -1, false, poseStack.method_23760().method_23761(), buffers, class_327.class_6415.field_33994, 0, 0xF000F0);
        }
        poseStack.method_22909();
    }

    private static boolean isWithinChunkRadius(class_2338 cameraBlockPos, class_2338 targetBlockPos, int chunkRadius) {
        int camChunkX = class_4076.method_18675((int)cameraBlockPos.method_10263());
        int camChunkZ = class_4076.method_18675((int)cameraBlockPos.method_10260());
        int tgtChunkX = class_4076.method_18675((int)targetBlockPos.method_10263());
        int tgtChunkZ = class_4076.method_18675((int)targetBlockPos.method_10260());
        return Math.max(Math.abs(tgtChunkX - camChunkX), Math.abs(tgtChunkZ - camChunkZ)) <= chunkRadius;
    }

    private static boolean isWithinChunkRadius(class_2338 cameraBlockPos, int targetX, int targetY, int targetZ, int chunkRadius) {
        return StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPos, new class_2338(targetX, targetY, targetZ), chunkRadius);
    }
}

