/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.controller;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.StructurifyClient;
import com.faboslav.structurify.common.config.client.gui.StructureConfigScreen;
import com.faboslav.structurify.common.config.client.gui.StructurifyConfigScreen;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.BooleanController;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class StructureButtonController
extends BooleanController {
    private final String structureId;

    public StructureButtonController(Option<Boolean> option, String structureId, Function<Boolean, Component> valueFormatter, boolean coloured) {
        super(option, valueFormatter, coloured);
        this.structureId = structureId;
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new BooleanWithButtonControllerElement(this, screen, widgetDimension, this.structureId);
    }

    public static class BooleanWithButtonControllerElement
    extends BooleanController.BooleanControllerElement {
        private final TextScaledButtonWidget configurationButton;

        public BooleanWithButtonControllerElement(BooleanController control, YACLScreen screen, Dimension<Integer> dim, String structureId) {
            super(control, screen, dim);
            this.setDimension(this.getDimension().expanded((Number)-20, (Number)0));
            this.configurationButton = new TextScaledButtonWidget((Screen)screen, ((Integer)this.getDimension().xLimit()).intValue(), -50, 20, 20, 1.0f, (Component)Component.literal((String)"\u2699").withStyle(style -> style.withBold(Boolean.valueOf(true))), button -> {
                StructurifyConfigScreen configScreen = StructurifyClient.getConfigScreen();
                if (configScreen == null) {
                    return;
                }
                screen.finishOrSave();
                YACLScreen structureScreen = StructureConfigScreen.create(Structurify.getConfig(), structureId, (Screen)screen);
                configScreen.saveScreenState(screen);
                this.client.setScreen((Screen)structureScreen);
                configScreen.loadScreenState(structureScreen);
            });
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.configurationButton.setY(((Integer)this.getDimension().y()).intValue());
            this.configurationButton.render(graphics, mouseX, mouseY, delta);
            this.configurationButton.active = this.isAvailable();
            super.render(graphics, mouseX, mouseY, delta);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.configurationButton.mouseMoved(mouseX, mouseY);
            super.mouseMoved(mouseX, mouseY);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.configurationButton.isMouseOver(mouseX, mouseY) || super.isMouseOver(mouseX, mouseY);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.configurationButton.mouseClicked(mouseX, mouseY, button) || super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.configurationButton.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.configurationButton.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            return this.configurationButton.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
    }
}

