/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.controller.element;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.Nullable;

public final class DualControllerElement
extends AbstractWidget {
    private final AbstractWidget labelElement;
    private final AbstractWidget firstElement;
    private final AbstractWidget secondElement;
    @Nullable
    private final TextScaledButtonWidget resetButton;

    public DualControllerElement(Dimension<Integer> dim, AbstractWidget labelElement, AbstractWidget firstElement, AbstractWidget secondElement, @Nullable TextScaledButtonWidget resetButton) {
        super(dim);
        this.labelElement = labelElement;
        this.firstElement = firstElement;
        this.secondElement = secondElement;
        this.resetButton = resetButton;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.labelElement.mouseMoved(mouseX, mouseY);
        this.firstElement.mouseMoved(mouseX, mouseY);
        this.secondElement.mouseMoved(mouseX, mouseY);
        this.resetButton.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        boolean firstElementMouseClicked = this.firstElement.mouseClicked(mouseButtonEvent, doubleClick);
        boolean secondElementMouseClicked = this.secondElement.mouseClicked(mouseButtonEvent, doubleClick);
        boolean resetButtonMouseClicked = this.resetButton.mouseClicked(mouseButtonEvent, doubleClick);
        return firstElementMouseClicked || secondElementMouseClicked || resetButtonMouseClicked;
    }

    public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
        boolean firstElementMouseReleased = this.firstElement.mouseReleased(mouseButtonEvent);
        boolean secondElementMouseReleased = this.secondElement.mouseReleased(mouseButtonEvent);
        boolean resetButtonMouseReleased = this.resetButton.mouseReleased(mouseButtonEvent);
        return firstElementMouseReleased || secondElementMouseReleased || resetButtonMouseReleased;
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dx, double dy) {
        return this.firstElement.mouseDragged(mouseButtonEvent, dx, dy) || this.secondElement.mouseDragged(mouseButtonEvent, dx, dy) || this.resetButton.mouseDragged(mouseButtonEvent, dx, dy);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return this.firstElement.keyPressed(keyEvent) || this.secondElement.keyPressed(keyEvent) || this.resetButton.keyPressed(keyEvent);
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        return this.firstElement.keyReleased(keyEvent) || this.secondElement.keyReleased(keyEvent) || this.resetButton.keyReleased(keyEvent);
    }

    public boolean charTyped(CharacterEvent characterEvent) {
        return this.firstElement.charTyped(characterEvent) || this.secondElement.charTyped(characterEvent) || this.secondElement.charTyped(characterEvent);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.firstElement.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount) || this.secondElement.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void setFocused(boolean focused) {
        this.firstElement.setFocused(focused);
        this.secondElement.setFocused(focused);
    }

    public boolean isFocused() {
        return this.firstElement.isFocused() || this.secondElement.isFocused();
    }

    public void setDimension(Dimension<Integer> dim) {
        Dimension firstElementDimension = dim.moved((Number)0, (Number)0).withWidth((Number)((Integer)this.firstElement.getDimension().width())).withHeight((Number)((Integer)this.firstElement.getDimension().height()));
        Dimension secondElementDimension = dim.moved((Number)((Integer)this.firstElement.getDimension().width()), (Number)0).withWidth((Number)((Integer)this.secondElement.getDimension().width())).withHeight((Number)((Integer)this.secondElement.getDimension().height()));
        this.firstElement.setDimension(firstElementDimension);
        this.secondElement.setDimension(secondElementDimension);
        if (this.resetButton != null) {
            this.resetButton.setY(((Integer)this.getDimension().y()).intValue());
        }
        super.setDimension(dim);
    }

    public void unfocus() {
        this.firstElement.unfocus();
        this.secondElement.unfocus();
        super.unfocus();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float tickDelta) {
        this.firstElement.render(graphics, mouseX, mouseY, tickDelta);
        this.secondElement.render(graphics, mouseX, mouseY, tickDelta);
        if (this.resetButton != null) {
            this.resetButton.setY(((Integer)this.getDimension().y()).intValue());
            this.resetButton.render(graphics, mouseX, mouseY, tickDelta);
        }
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public boolean matchesSearch(String query) {
        boolean matchesSearchInLabel = this.labelElement.matchesSearch(query);
        boolean matchesSearchInFirstElement = this.firstElement.matchesSearch(query);
        boolean matchesSearchInSecondElement = this.firstElement.matchesSearch(query);
        return matchesSearchInLabel || matchesSearchInFirstElement || matchesSearchInSecondElement;
    }

    public void updateNarration(NarrationElementOutput builder) {
        this.firstElement.updateNarration(builder);
        this.secondElement.updateNarration(builder);
    }
}

