/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.util;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.mixin.structure.jigsaw.JigsawStructureAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.Optional;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public final class JigsawStructureUtil {
    public static boolean isJigsawLikeStructure(Structure structure) {
        Field[] fields;
        if (structure instanceof JigsawStructure) {
            return true;
        }
        Class<?> clazz = structure.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals("maxDistanceFromCenter") && !field.getName().equals("maxDepth") && !field.getName().equals("size")) continue;
            return true;
        }
        return false;
    }

    public static JigsawStructure.MaxDistance getMaxDistanceFromCenterForStructure(Structure structure) {
        Field[] fields;
        if (structure instanceof JigsawStructure) {
            return ((JigsawStructureAccessor)structure).structurify$getMaxDistanceFromCenter();
        }
        Class<?> clazz = structure.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals("maxDistanceFromCenter")) continue;
            field.setAccessible(true);
            try {
                Object val;
                Field target = null;
                for (Field f : structure.getClass().getDeclaredFields()) {
                    if (!f.getName().equals("maxDistanceFromCenter")) continue;
                    target = f;
                    break;
                }
                if (target == null) {
                    return new JigsawStructure.MaxDistance(0, 0);
                }
                target.setAccessible(true);
                Object raw = target.get(structure);
                if (raw instanceof Optional) {
                    Optional opt = (Optional)raw;
                    v0 = opt.orElse(null);
                } else {
                    v0 = val = raw;
                }
                if (val == null) {
                    return new JigsawStructure.MaxDistance(0, 0);
                }
                if (val instanceof Integer) {
                    Integer i = (Integer)val;
                    return new JigsawStructure.MaxDistance(i.intValue(), i.intValue());
                }
                try {
                    Method horizontalMethod = val.getClass().getMethod("horizontal", new Class[0]);
                    Method verticalMethod = val.getClass().getMethod("vertical", new Class[0]);
                    int horizontal = ((Number)horizontalMethod.invoke(val, new Object[0])).intValue();
                    int vertical = ((Number)verticalMethod.invoke(val, new Object[0])).intValue();
                    return new JigsawStructure.MaxDistance(horizontal, vertical);
                }
                catch (NoSuchMethodException ignore) {
                    int horizontal = 0;
                    int vertical = 0;
                    if (val.getClass().isRecord()) {
                        for (RecordComponent recordComponent : val.getClass().getRecordComponents()) {
                            if (recordComponent.getName().equals("horizontal")) {
                                horizontal = ((Number)recordComponent.getAccessor().invoke(val, new Object[0])).intValue();
                                continue;
                            }
                            if (!recordComponent.getName().equals("vertical")) continue;
                            vertical = ((Number)recordComponent.getAccessor().invoke(val, new Object[0])).intValue();
                        }
                        if (horizontal != 0 || vertical != 0) {
                            return new JigsawStructure.MaxDistance(horizontal == 0 ? vertical : horizontal, vertical == 0 ? horizontal : vertical);
                        }
                    }
                    try {
                        Field horizontalField = val.getClass().getDeclaredField("horizontal");
                        Field verticalField = val.getClass().getDeclaredField("vertical");
                        horizontalField.setAccessible(true);
                        verticalField.setAccessible(true);
                        horizontal = ((Number)horizontalField.get(val)).intValue();
                        vertical = ((Number)verticalField.get(val)).intValue();
                        return new JigsawStructure.MaxDistance(horizontal, vertical);
                    }
                    catch (NoSuchFieldException e) {
                        Structurify.getLogger().error(e.getMessage());
                    }
                }
            }
            catch (Throwable e) {
                Structurify.getLogger().error(e.getMessage());
            }
            break;
        }
        return new JigsawStructure.MaxDistance(0, 0);
    }

    public static int getSizeForStructure(Structure structure) {
        Field[] fields;
        if (structure instanceof JigsawStructure) {
            return ((JigsawStructureAccessor)structure).structurify$getMaxDepth();
        }
        Class<?> clazz = structure.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals("size") && !field.getName().equals("max_depth")) continue;
            field.setAccessible(true);
            try {
                if (Optional.class.isAssignableFrom(field.getType())) {
                    Optional optionalValue = (Optional)field.get(structure);
                    return optionalValue.map(val -> (Integer)val).orElse(0);
                }
                return field.getInt(structure);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Structurify.getLogger().error(e.getMessage());
                break;
            }
        }
        return 0;
    }
}

