/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.world.level.structure.StructureSectionClaim;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_4076;

public final class StructureOverlapCheck {
    public static boolean checkForOverlap(StructureCheckData structureCheckData, StructurifyChunkGenerator structurifyChunkGenerator) {
        long[] structureChunks = StructureOverlapCheck.getStructurePiecesSections(structureCheckData.getStructureStart());
        return !StructureOverlapCheck.claimStructureSections(structurifyChunkGenerator, structureChunks, structureCheckData.getStructureId());
    }

    private static long[] getStructurePiecesSections(class_3449 start) {
        HashSet<Long> structurePieceSectionUniqueKeys = new HashSet<Long>();
        for (class_3443 piece : start.method_14963()) {
            class_3341 b = piece.method_14935();
            int minSx = class_4076.method_18675((int)b.method_35415());
            int maxSx = class_4076.method_18675((int)b.method_35418());
            int minSz = class_4076.method_18675((int)b.method_35417());
            int maxSz = class_4076.method_18675((int)b.method_35420());
            int minSy = class_4076.method_18675((int)b.method_35416());
            int maxSy = class_4076.method_18675((int)b.method_35419());
            for (int sz = minSz; sz <= maxSz; ++sz) {
                for (int sx = minSx; sx <= maxSx; ++sx) {
                    for (int sy = minSy; sy <= maxSy; ++sy) {
                        structurePieceSectionUniqueKeys.add(class_4076.method_18685((int)sx, (int)sy, (int)sz));
                    }
                }
            }
        }
        long[] structurePieceSectionKeys = new long[structurePieceSectionUniqueKeys.size()];
        int i = 0;
        for (Long structurePieceSectionKey : structurePieceSectionUniqueKeys) {
            structurePieceSectionKeys[i++] = structurePieceSectionKey;
        }
        return structurePieceSectionKeys;
    }

    private static boolean claimStructureSections(StructurifyChunkGenerator structurifyChunkGenerator, long[] sectionKeysToClaim, class_2960 structureId) {
        long token = ThreadLocalRandom.current().nextLong();
        long[] salted = new long[sectionKeysToClaim.length];
        for (int acquired = 0; acquired < sectionKeysToClaim.length; ++acquired) {
            long key;
            salted[acquired] = key = sectionKeysToClaim[acquired];
            StructureSectionClaim structureSectionClaim = new StructureSectionClaim(token, structureId);
            StructureSectionClaim prev = structurifyChunkGenerator.structurify$getStructureSectionClaims().putIfAbsent(key, structureSectionClaim);
            if (prev == null) continue;
            for (int i = 0; i < acquired; ++i) {
                structurifyChunkGenerator.structurify$getStructureSectionClaims().remove(salted[i], structureSectionClaim);
            }
            return false;
        }
        return true;
    }
}

