/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckSample;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public final class StructureFlatnessCheck {
    @Nullable
    public static FlatnessCheckData getFlatnessCheckData(StructureCheckData structureCheckData) {
        FlatnessCheckData structureFlatnessCheckData;
        FlatnessCheckData namespaceFlatnessCheckData;
        StructurifyStructure structure = structureCheckData.getStructure();
        ResourceLocation structureId = structureCheckData.getStructureId();
        StructureNamespaceData globalNamespaceData = structure.structurify$getGlobalStructureNamespaceData();
        StructureNamespaceData structureNamespaceData = structure.structurify$getStructureNamespaceData(structureId);
        StructureData structureData = structure.structurify$getStructureData(structureId);
        FlatnessCheckData flatnessCheckDataToCheck = null;
        if (globalNamespaceData != null) {
            flatnessCheckDataToCheck = globalNamespaceData.getFlatnessCheckData();
        }
        if (structureNamespaceData != null && ((namespaceFlatnessCheckData = structureNamespaceData.getFlatnessCheckData()).isOverridingGlobalFlatnessCheck() || namespaceFlatnessCheckData.isEnabled())) {
            flatnessCheckDataToCheck = namespaceFlatnessCheckData;
        }
        if (structureData != null && ((structureFlatnessCheckData = structureData.getFlatnessCheckData()).isOverridingGlobalFlatnessCheck() || structureFlatnessCheckData.isEnabled())) {
            flatnessCheckDataToCheck = structureFlatnessCheckData;
        }
        return flatnessCheckDataToCheck;
    }

    public static boolean canDoFlatnessCheck(StructureCheckData structureCheckData) {
        StructurifyStructure structure = structureCheckData.getStructure();
        FlatnessCheckData flatnessCheckData = StructureFlatnessCheck.getFlatnessCheckData(structureCheckData);
        if (flatnessCheckData == null || !flatnessCheckData.isEnabled()) {
            return false;
        }
        StructureData structureData = structure.structurify$getStructureData();
        return structureData != null;
    }

    public static boolean checkFlatness(StructureCheckData structureCheckData, FlatnessCheckData flatnessCheckData, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState) {
        List<StructurePiece> structurePieces = structureCheckData.getStructurePieces();
        int[][] structurePieceSamples = structureCheckData.getStructurePieceSamples();
        ResourceLocation structureId = structureCheckData.getStructureId();
        StructureStart structureStart = structureCheckData.getStructureStart();
        BlockPos structureCenter = structureCheckData.getStructureCenter();
        HashSet<StructureFlatnessCheckSample> flatnessCheckSamples = new HashSet<StructureFlatnessCheckSample>();
        int structureArea = 0;
        for (StructurePiece structurePiece : structurePieces) {
            BoundingBox structurePieceBoundingBox = structurePiece.getBoundingBox();
            int spanX = structurePieceBoundingBox.getXSpan();
            int spanZ = structurePieceBoundingBox.getZSpan();
            structureArea += spanX * spanZ;
        }
        int flatnessCheckHeightThreshold = Mth.clamp((int)((int)Math.round(Math.sqrt(structureArea) * 0.33)), (int)3, (int)21);
        int totalFlatnessChecks = structurePieceSamples.length;
        int nonSolidFlatnessChecks = 0;
        int nonSolidFlatnessChecksThreshold = Math.max(1, (int)Math.floor((double)totalFlatnessChecks * 0.33 * Math.pow(Math.min(1.0, (double)totalFlatnessChecks / 100.0), 0.33)));
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        for (int currentFlatnessCheck = 0; currentFlatnessCheck < totalFlatnessChecks; ++currentFlatnessCheck) {
            int x = structurePieceSamples[currentFlatnessCheck][0];
            int z = structurePieceSamples[currentFlatnessCheck][1];
            int firstOceanFloorOccupiedHeight = chunkGenerator.getFirstOccupiedHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, heightAccessor, randomState);
            if (firstOceanFloorOccupiedHeight > maxHeight && (maxHeight = firstOceanFloorOccupiedHeight) - minHeight > flatnessCheckHeightThreshold) {
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(ChunkPos.asLong((BlockPos)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.getBoundingBox(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            if (firstOceanFloorOccupiedHeight < minHeight && maxHeight - (minHeight = firstOceanFloorOccupiedHeight) > flatnessCheckHeightThreshold) {
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(ChunkPos.asLong((BlockPos)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.getBoundingBox(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            if (!flatnessCheckData.areNonSolidBlocksAllowed()) {
                boolean isSolid;
                int remainingFlatnessChecks = totalFlatnessChecks - currentFlatnessCheck;
                if (nonSolidFlatnessChecks + remainingFlatnessChecks < nonSolidFlatnessChecksThreshold && !Structurify.getConfig().getDebugData().isEnabled()) continue;
                int firstWorldSurfaceFreeHeight = chunkGenerator.getFirstFreeHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState);
                boolean bl = isSolid = firstWorldSurfaceFreeHeight - firstOceanFloorOccupiedHeight == 1;
                if (Structurify.getConfig().getDebugData().isEnabled()) {
                    flatnessCheckSamples.add(new StructureFlatnessCheckSample(structureId, x, z, firstOceanFloorOccupiedHeight, firstWorldSurfaceFreeHeight, isSolid));
                }
                if (isSolid || ++nonSolidFlatnessChecks < nonSolidFlatnessChecksThreshold) continue;
                Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(ChunkPos.asLong((BlockPos)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.getBoundingBox(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, false));
                return false;
            }
            flatnessCheckSamples.add(new StructureFlatnessCheckSample(structureId, x, z, firstOceanFloorOccupiedHeight, firstOceanFloorOccupiedHeight, true));
        }
        flatnessCheckSamples.forEach(flatnessCheckSample -> Structurify.getConfig().getDebugData().addStructureFlatnessCheckSample(ChunkPos.asLong((BlockPos)structureCenter), (StructureFlatnessCheckSample)flatnessCheckSample));
        Structurify.getConfig().getDebugData().addStructureFlatnessCheckInfo(ChunkPos.asLong((BlockPos)structureCenter), new StructureFlatnessCheckOverview(structureId, structureStart.getBoundingBox(), structurePieces, structureArea, minHeight, maxHeight, flatnessCheckHeightThreshold, totalFlatnessChecks, nonSolidFlatnessChecks, nonSolidFlatnessChecksThreshold, true));
        return true;
    }

    private StructureFlatnessCheck() {
    }
}

