/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.world.level.structure.StructureSectionClaim;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public final class StructureOverlapCheck {
    public static boolean checkForOverlap(StructureCheckData structureCheckData, StructurifyChunkGenerator structurifyChunkGenerator) {
        StructureStart start = structureCheckData.getStructureStart();
        long[] structureCells = StructureOverlapCheck.getStructurePiecesSections(start);
        long structureCenter = start.m_73601_().m_162394_().m_121878_();
        boolean overlapCheckResult = !StructureOverlapCheck.claimStructureSections(structurifyChunkGenerator, structureCells, structureCheckData.getStructureId(), structureCenter);
        return overlapCheckResult;
    }

    private static long[] getStructurePiecesSections(StructureStart start) {
        HashSet<Long> structurePieceSectionUniqueKeys = new HashSet<Long>();
        for (StructurePiece piece : start.m_73602_()) {
            BoundingBox b = piece.m_73547_();
            int minSx = SectionPos.m_123171_((int)b.m_162395_());
            int maxSx = SectionPos.m_123171_((int)b.m_162399_());
            int minSz = SectionPos.m_123171_((int)b.m_162398_());
            int maxSz = SectionPos.m_123171_((int)b.m_162401_());
            int minSy = SectionPos.m_123171_((int)b.m_162396_());
            int maxSy = SectionPos.m_123171_((int)b.m_162400_());
            for (int sz = minSz; sz <= maxSz; ++sz) {
                for (int sx = minSx; sx <= maxSx; ++sx) {
                    for (int sy = minSy; sy <= maxSy; ++sy) {
                        structurePieceSectionUniqueKeys.add(SectionPos.m_123209_((int)sx, (int)sy, (int)sz));
                    }
                }
            }
        }
        long[] structurePieceSectionKeys = new long[structurePieceSectionUniqueKeys.size()];
        int i = 0;
        for (Long structurePieceSectionKey : structurePieceSectionUniqueKeys) {
            structurePieceSectionKeys[i++] = structurePieceSectionKey;
        }
        return structurePieceSectionKeys;
    }

    private static boolean claimStructureSections(StructurifyChunkGenerator gen, long[] sectionKeysToClaim, ResourceLocation structureId, long structureCenter) {
        long token = ThreadLocalRandom.current().nextLong();
        StructureSectionClaim claim = new StructureSectionClaim(token, structureId.toString(), structureCenter);
        long[] claimed = new long[sectionKeysToClaim.length];
        for (int acquired = 0; acquired < sectionKeysToClaim.length; ++acquired) {
            long key;
            claimed[acquired] = key = sectionKeysToClaim[acquired];
            StructureSectionClaim prev = gen.structurify$getStructureSectionClaims().putIfAbsent(key, claim);
            if (prev == null || structureId.toString().equals(prev.structureId()) && structureCenter == prev.structureCenter()) continue;
            for (int i = 0; i < acquired; ++i) {
                gen.structurify$getStructureSectionClaims().remove(claimed[i], claim);
            }
            return false;
        }
        return true;
    }
}

