/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.BiomeStringControllerBuilder;
import com.faboslav.structurify.common.config.client.api.option.InvisibleOptionGroup;
import com.faboslav.structurify.common.config.client.gui.structure.BiomeCheckOptions;
import com.faboslav.structurify.common.config.client.gui.structure.DistanceFromWorldCenterOptions;
import com.faboslav.structurify.common.config.client.gui.structure.FlatnessCheckOptions;
import com.faboslav.structurify.common.config.client.gui.structure.JigsawOptions;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionAddable;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public final class StructureConfigScreen {
    public static YACLScreen create(StructurifyConfig config, String structureId, Screen parent) {
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((Component)Component.m_237113_((String)structureId)).save(config::save);
        StructureData structureData = config.getStructureData().get(structureId);
        MutableComponent translatedStructureName = LanguageUtil.translateId("structure", structureId);
        ConfigCategory.Builder structureCategoryBuilder = ConfigCategory.createBuilder().name((Component)Component.m_237110_((String)"gui.structurify.structures.structure.title", (Object[])new Object[]{translatedStructureName})).tooltip(new Component[]{Component.m_237110_((String)"gui.structurify.structures.structure.description", (Object[])new Object[]{translatedStructureName})});
        OptionGroup.Builder structureSettingsGroup = new InvisibleOptionGroup.Builder().name((Component)Component.m_237113_((String)"test"));
        structureSettingsGroup.option((Option)LabelOption.create((Component)Component.m_237115_((String)"gui.structurify.structures.structures.structure.title").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)))));
        Option isDisabledOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.structure.is_disabled.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.structure.is_disabled.description")})).binding((Object)false, () -> config.getStructureData().get(structureId).isDisabled(), isDisabled -> config.getStructureData().get(structureId).setDisabled((boolean)isDisabled)).controller(opt -> BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes").m_130938_(style -> style.m_131140_(ChatFormatting.RED)) : Component.m_237115_((String)"gui.structurify.label.no").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)))).build();
        structureSettingsGroup.option(isDisabledOption);
        Option stepOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.structure.step.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.structure.step.description")})).binding((Object)config.getStructureData().get(structureId).getDefaultStep(), () -> config.getStructureData().get(structureId).getStep(), step -> config.getStructureData().get(structureId).setStep((GenerationStep.Decoration)step)).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(GenerationStep.Decoration.class).valueFormatter(step -> Component.m_237115_((String)StructureConfigScreen.getHumanReadableName(step.name().toLowerCase())))).build();
        structureSettingsGroup.option(stepOption);
        Option terrainAdaptationOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.structure.terrain_adaptation.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.structure.terrain_adaptation.description")})).binding((Object)config.getStructureData().get(structureId).getDefaultTerrainAdaptation(), () -> config.getStructureData().get(structureId).getTerrainAdaptation(), terrainAdaptation -> config.getStructureData().get(structureId).setTerrainAdaptation((TerrainAdjustment)terrainAdaptation)).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(TerrainAdjustment.class).valueFormatter(terrainAdaptation -> Component.m_237115_((String)StructureConfigScreen.getHumanReadableName(terrainAdaptation.name().toLowerCase())))).build();
        structureSettingsGroup.option(terrainAdaptationOption);
        if (config.getStructureData().get(structureId).isJigsawStructure()) {
            ArrayList<Option<?>> jigsawOptions = JigsawOptions.getJigsawCheckOptions(structureData);
            structureSettingsGroup.options(jigsawOptions);
            isDisabledOption.addListener((opt, currentIsDisabled) -> {
                for (Option jigsawOption : jigsawOptions) {
                    jigsawOption.setAvailable(currentIsDisabled == false);
                }
            });
        }
        structureCategoryBuilder.group(structureSettingsGroup.build());
        ListOption biomesOption = ListOption.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.structure.biomes.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237110_((String)"gui.structurify.structures.structure.biomes.description", (Object[])new Object[]{translatedStructureName})})).insertEntriesAtEnd(false).binding(config.getStructureData().get(structureId).getDefaultBiomes(), () -> config.getStructureData().get(structureId).getBiomes(), biomes -> config.getStructureData().get(structureId).setBiomes((List<String>)biomes)).controller(BiomeStringControllerBuilder::create).initial((Object)"").build();
        structureCategoryBuilder.group((OptionGroup)biomesOption);
        OptionGroup.Builder distanceFromWorldCenterOptionsGroup = new InvisibleOptionGroup.Builder().name((Component)Component.m_237113_((String)"distance"));
        DistanceFromWorldCenterOptions.addDistanceFromWorldCenterOptions((OptionAddable)distanceFromWorldCenterOptionsGroup, config, structureId);
        structureCategoryBuilder.group(distanceFromWorldCenterOptionsGroup.build());
        OptionGroup.Builder flatnessOptionsGroup = new InvisibleOptionGroup.Builder().name((Component)Component.m_237113_((String)"flatness"));
        FlatnessCheckOptions.addFlatnessCheckOptions((OptionAddable)flatnessOptionsGroup, config, structureId);
        structureCategoryBuilder.group(flatnessOptionsGroup.build());
        OptionGroup.Builder biomesOptionsGroup = new InvisibleOptionGroup.Builder().name((Component)Component.m_237113_((String)"biomes"));
        Map<String, Option<?>> biomeCheckOptions = BiomeCheckOptions.addBiomeCheckOptions(structureCategoryBuilder, biomesOptionsGroup, config, structureId);
        structureCategoryBuilder.group(biomesOptionsGroup.build());
        Option<?> blacklistedBiomesOption = biomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_BLACKLISTED_BIOMES_OPTION_NAME);
        structureCategoryBuilder.group((OptionGroup)blacklistedBiomesOption);
        yacl.category(structureCategoryBuilder.build());
        return (YACLScreen)yacl.build().generateScreen(parent);
    }

    private static String getHumanReadableName(String serializedName) {
        return Arrays.stream(serializedName.split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" "));
    }
}

