/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.mixin;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.structure.DistanceFromWorldCenterCheckData;
import com.faboslav.structurify.world.level.structure.StructureSectionClaim;
import com.faboslav.structurify.world.level.structure.checks.DistanceFromWorldCenterCheck;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ChunkGenerator.class})
public final class ChunkGeneratorMixin
implements StructurifyChunkGenerator {
    @Unique
    private final Map<Long, StructureSectionClaim> structurify$structureSectionClaims = new ConcurrentHashMap<Long, StructureSectionClaim>();

    @Override
    @Unique
    public Map<Long, StructureSectionClaim> structurify$getStructureSectionClaims() {
        return this.structurify$structureSectionClaims;
    }

    @WrapMethod(method={"tryGenerateStructure"})
    public boolean structurify$trySetStructureStart(StructureSet.StructureSelectionEntry structureSelectionEntry, StructureManager structureManager, RegistryAccess registryAccess, RandomState randomState, StructureTemplateManager structureTemplateManager, long seed, ChunkAccess chunkAccess, ChunkPos chunkPos, SectionPos sectionPos, Operation<Boolean> original) {
        if (Structurify.getConfig().disableAllStructures) {
            return false;
        }
        Optional structureKey = structureSelectionEntry.f_210026_().m_203543_();
        if (structureKey.isPresent()) {
            ResourceLocation structureName = ((ResourceKey)structureKey.get()).m_135782_();
            StructureData structureData = Structurify.getConfig().getStructureData().getOrDefault(structureName.toString(), null);
            if (structureData != null) {
                if (structureData.isDisabled()) {
                    return false;
                }
                DistanceFromWorldCenterCheckData distanceFromWorldCenterCheckData = DistanceFromWorldCenterCheck.getDistanceFromWorldCenterData(structureName, structureData);
                boolean distanceFromWorldCenterCheckResult = DistanceFromWorldCenterCheck.checkDistanceFromWorldCenter(distanceFromWorldCenterCheckData, chunkPos);
                if (!distanceFromWorldCenterCheckResult) {
                    return false;
                }
            }
        }
        return (Boolean)original.call(new Object[]{structureSelectionEntry, structureManager, registryAccess, randomState, structureTemplateManager, seed, chunkAccess, chunkPos, sectionPos});
    }

    @WrapMethod(method={"findNearestMapStructure"})
    public Pair<BlockPos, Holder<Structure>> structurify$findNearestMapStructure(ServerLevel serverLevel, HolderSet<Structure> holderSet, BlockPos blockPos, int i, boolean bl, Operation<Pair<BlockPos, Holder<Structure>>> original) {
        if (Structurify.getConfig().disableAllStructures) {
            return null;
        }
        boolean areAllStructureDisabled = true;
        for (Holder holder : holderSet) {
            Optional structureKey = holder.m_203543_();
            if (structureKey.isEmpty()) continue;
            String structureName = ((ResourceKey)structureKey.get()).m_135782_().toString();
            StructureData structureData = Structurify.getConfig().getStructureData().getOrDefault(structureName, null);
            if (structureData != null && structureData.isDisabled()) continue;
            areAllStructureDisabled = false;
        }
        if (areAllStructureDisabled) {
            return null;
        }
        return (Pair)original.call(new Object[]{serverLevel, holderSet, blockPos, i, bl});
    }
}

