/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.util;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.modcompat.ModChecker;
import com.faboslav.structurify.common.modcompat.ModCompat;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public final class BiomeUtil {
    public static TagKey<Biome> C_IS_OCEAN = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)Structurify.makeNamespacedId("c:is_ocean"));

    public static Set<ResourceKey<Biome>> getOceanBiomes() {
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return new HashSet<ResourceKey<Biome>>();
        }
        HashSet<ResourceKey<Biome>> oceanBiomes = new HashSet<ResourceKey<Biome>>();
        biomeRegistry.m_254901_(BiomeTags.f_207603_).ifPresent(named -> oceanBiomes.addAll(named.m_203614_().map(h -> h.m_203543_().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        biomeRegistry.m_254901_(BiomeTags.f_207605_).ifPresent(named -> oceanBiomes.addAll(named.m_203614_().map(h -> h.m_203543_().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        biomeRegistry.m_254901_(C_IS_OCEAN).ifPresent(named -> oceanBiomes.addAll(named.m_203614_().map(h -> h.m_203543_().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        return oceanBiomes;
    }

    public static HolderSet<Biome> getBiomes(ResourceLocation structureId, HolderSet<Biome> originalBiomes) {
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return originalBiomes;
        }
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return originalBiomes;
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        List<String> biomeIds = structureData.getBiomes();
        return BiomeUtil.getBiomeHolders(biomeIds, biomeRegistry);
    }

    public static HolderSet<Biome> getBlacklistedBiomes(ResourceLocation structureId) {
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return HolderSet.m_205800_(new ArrayList());
        }
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return HolderSet.m_205800_(new ArrayList());
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        List<String> blacklistedBiomeIds = structureData.getBiomeCheckData().getBlacklistedBiomes();
        return BiomeUtil.getBiomeHolders(blacklistedBiomeIds, biomeRegistry);
    }

    public static HolderSet<Biome> getBiomeHolders(List<String> biomeIds, HolderLookup.RegistryLookup<Biome> biomeRegistry) {
        for (ModCompat modCompat : ModChecker.BIOME_REPLACER_COMPATS) {
            try {
                List<String> replacedBiomeIds = modCompat.getReplacedBiomes(biomeIds);
                biomeIds.addAll(replacedBiomeIds);
            }
            catch (Throwable e) {
                Structurify.getLogger().error("Failed to get replaced biomes from mod compat");
                e.printStackTrace();
            }
        }
        ArrayList<Object> biomeHolders = new ArrayList<Object>();
        for (String biomeId : biomeIds) {
            if (biomeId.contains("#")) {
                TagKey biomeTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)Structurify.makeNamespacedId(biomeId.replace("#", "")));
                HolderSet.Named biomeTagHolder = biomeRegistry.m_254901_(biomeTagKey).orElse(null);
                if (biomeTagHolder == null) continue;
                for (Holder biomeHolder : biomeTagHolder.m_203614_().toList()) {
                    biomeHolders.add(biomeHolder);
                }
                continue;
            }
            ResourceKey biomeResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Structurify.makeNamespacedId(biomeId.replace("#", "")));
            Holder.Reference biomeHolder = biomeRegistry.m_254902_(biomeResourceKey).orElse(null);
            if (biomeHolder == null) continue;
            biomeHolders.add(biomeHolder);
        }
        return HolderSet.m_205800_(biomeHolders);
    }
}

