/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.structure.DistanceFromWorldCenterCheckData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public class DistanceFromWorldCenterCheck {
    public static DistanceFromWorldCenterCheckData getDistanceFromWorldCenterData(ResourceLocation structureId, StructureData structureData) {
        StructureNamespaceData globalStructureData = Structurify.getConfig().getStructureNamespaceData().get(StructureNamespaceData.GLOBAL_NAMESPACE_IDENTIFIER);
        StructureNamespaceData namespacedStructureData = Structurify.getConfig().getStructureNamespaceData().get(structureId.m_135827_());
        DistanceFromWorldCenterCheckData globalDistanceFromWorldCenterData = globalStructureData.getDistanceFromWorldCenterCheckData();
        DistanceFromWorldCenterCheckData namespaceDistanceFromWorldCenterData = namespacedStructureData.getDistanceFromWorldCenterCheckData();
        DistanceFromWorldCenterCheckData structureDistanceFromWorldCenterData = structureData.getDistanceFromWorldCenterCheckData();
        DistanceFromWorldCenterCheckData distanceFromWorldCenterCheckDataToCheck = globalDistanceFromWorldCenterData;
        if (namespaceDistanceFromWorldCenterData.isOverridingGlobalDistanceFromWorldCenter()) {
            distanceFromWorldCenterCheckDataToCheck = namespaceDistanceFromWorldCenterData;
        }
        if (structureDistanceFromWorldCenterData.isOverridingGlobalDistanceFromWorldCenter()) {
            distanceFromWorldCenterCheckDataToCheck = structureDistanceFromWorldCenterData;
        }
        return distanceFromWorldCenterCheckDataToCheck;
    }

    public static boolean checkDistanceFromWorldCenter(DistanceFromWorldCenterCheckData distanceFromWorldCenterCheckData, ChunkPos chunkPos) {
        int minDistanceFromWorldCenter = distanceFromWorldCenterCheckData.getMinDistanceFromWorldCenter();
        int maxDistanceFromWorldCenter = distanceFromWorldCenterCheckData.getMaxDistanceFromWorldCenter();
        if (minDistanceFromWorldCenter == 0 && maxDistanceFromWorldCenter == 0) {
            return true;
        }
        int distanceFromWorldCenter = chunkPos.m_45615_().m_123333_((Vec3i)BlockPos.f_121853_);
        boolean isFarEnoughFromWorldCenter = minDistanceFromWorldCenter == 0 || distanceFromWorldCenter >= minDistanceFromWorldCenter;
        boolean isCloseEnoughToWorldCenter = maxDistanceFromWorldCenter == 0 || distanceFromWorldCenter <= maxDistanceFromWorldCenter;
        return isFarEnoughFromWorldCenter && isCloseEnoughToWorldCenter;
    }
}

