/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.controller.element;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.Nullable;

public final class DualControllerElement
extends AbstractWidget {
    private final AbstractWidget firstElement;
    private final AbstractWidget secondElement;
    @Nullable
    private final TextScaledButtonWidget resetButton;

    public DualControllerElement(Dimension<Integer> dim, AbstractWidget firstElement, AbstractWidget secondElement, @Nullable TextScaledButtonWidget resetButton) {
        super(dim);
        this.firstElement = firstElement;
        this.secondElement = secondElement;
        this.resetButton = resetButton;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.firstElement.mouseMoved(mouseX, mouseY);
        this.secondElement.mouseMoved(mouseX, mouseY);
        this.resetButton.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.firstElement.setFocused(false);
        this.secondElement.setFocused(false);
        if (this.firstElement.mouseClicked(mouseX, mouseY, button)) {
            this.firstElement.setFocused(true);
            return true;
        }
        if (this.secondElement.mouseClicked(mouseX, mouseY, button)) {
            this.secondElement.setFocused(true);
            return true;
        }
        return this.resetButton.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.firstElement.mouseReleased(mouseX, mouseY, button) || this.secondElement.mouseReleased(mouseX, mouseY, button) || this.resetButton.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.firstElement.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || this.secondElement.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.firstElement.keyPressed(keyCode, scanCode, modifiers) || this.secondElement.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.firstElement.keyReleased(keyCode, scanCode, modifiers) || this.secondElement.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char chr, int modifiers) {
        return this.firstElement.charTyped(chr, modifiers) || this.secondElement.charTyped(chr, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.firstElement.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount) || this.secondElement.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void setFocused(boolean focused) {
    }

    public boolean isFocused() {
        return false;
    }

    public void setDimension(Dimension<Integer> dim) {
        Dimension firstElementDimension = dim.moved((Number)0, (Number)0).withWidth((Number)((Integer)this.firstElement.getDimension().width())).withHeight((Number)((Integer)this.firstElement.getDimension().height()));
        Dimension secondElementDimension = dim.moved((Number)((Integer)this.firstElement.getDimension().width()), (Number)0).withWidth((Number)((Integer)this.secondElement.getDimension().width())).withHeight((Number)((Integer)this.secondElement.getDimension().height()));
        this.firstElement.setDimension(firstElementDimension);
        this.secondElement.setDimension(secondElementDimension);
        if (this.resetButton != null) {
            this.resetButton.setY(((Integer)this.getDimension().y()).intValue());
        }
        super.setDimension(dim);
    }

    public void unfocus() {
        this.firstElement.unfocus();
        this.secondElement.unfocus();
        super.unfocus();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float tickDelta) {
        this.firstElement.render(graphics, mouseX, mouseY, tickDelta);
        this.secondElement.render(graphics, mouseX, mouseY, tickDelta);
        if (this.resetButton != null) {
            this.resetButton.setY(((Integer)this.getDimension().y()).intValue());
            this.resetButton.render(graphics, mouseX, mouseY, tickDelta);
        }
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public boolean matchesSearch(String query) {
        boolean matchesSearchInFirstElement = this.firstElement.matchesSearch(query);
        boolean matchesSearchInSecondElement = this.firstElement.matchesSearch(query);
        return matchesSearchInFirstElement || matchesSearchInSecondElement;
    }

    public void updateNarration(NarrationElementOutput builder) {
        this.firstElement.updateNarration(builder);
        this.secondElement.updateNarration(builder);
    }
}

