/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.world.level.structure.checks.StructureBiomeCheck;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import com.faboslav.structurify.world.level.structure.checks.StructureFlatnessCheck;
import com.faboslav.structurify.world.level.structure.checks.StructureOverlapCheck;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public final class StructureChecker {
    public static boolean checkStructure(StructureStart structureStart, @Nullable ResourceLocation structureId, StructurifyStructure structure, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState, BiomeSource biomeSource) {
        if (structureId == null) {
            structureId = structure.structurify$getStructureIdentifier();
        }
        if (structureId == null) {
            return true;
        }
        StructureCheckData structureCheckData = new StructureCheckData(structureId, structure, structureStart);
        long structureCheckId = StructureChecker.generateStructureCheckId(structureId, structureCheckData.getStructureCenter());
        StructurifyChunkGenerator structurifyChunkGenerator = (StructurifyChunkGenerator)chunkGenerator;
        Map<Long, Boolean> cachedBiomeChecks = structurifyChunkGenerator.structurify$getBiomeChecks();
        boolean biomeCheckResult = cachedBiomeChecks.computeIfAbsent(structureCheckId, id -> StructureChecker.checkBiomes(structureCheckData, biomeSource, randomState));
        if (!biomeCheckResult) {
            return false;
        }
        Map<Long, Boolean> cachedFlatnessChecks = structurifyChunkGenerator.structurify$getFlatnessChecks();
        boolean flatnessCheckResult = cachedFlatnessChecks.computeIfAbsent(structureCheckId, id -> StructureChecker.checkFlatness(structureCheckData, chunkGenerator, heightAccessor, randomState));
        if (!flatnessCheckResult) {
            return false;
        }
        Map<Long, Boolean> cachedOverlapChecks = structurifyChunkGenerator.structurify$getOverlapChecks();
        boolean overlapCheckResult = cachedOverlapChecks.computeIfAbsent(structureCheckId, id -> StructureChecker.checkOverlap(structureCheckData, structurifyChunkGenerator));
        return overlapCheckResult;
    }

    public static void debugCheckStructure(StructureStart structureStart, StructurifyStructure structure, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState, BiomeSource biomeSource) {
        ResourceLocation structureId = structure.structurify$getStructureIdentifier();
        StructureCheckData structureCheckData = new StructureCheckData(structureId, structure, structureStart);
        StructureChecker.checkBiomes(structureCheckData, biomeSource, randomState);
        StructureChecker.checkFlatness(structureCheckData, chunkGenerator, heightAccessor, randomState);
        StructureChecker.checkOverlap(structureCheckData, (StructurifyChunkGenerator)chunkGenerator);
    }

    private static boolean checkBiomes(StructureCheckData structureCheckData, BiomeSource biomeSource, RandomState randomState) {
        StructurifyStructure structure = structureCheckData.getStructure();
        BiomeCheckData biomeCheckData = StructureBiomeCheck.getBiomeCheckData(structureCheckData);
        if (biomeCheckData == null || !biomeCheckData.isEnabled()) {
            return true;
        }
        if (biomeSource instanceof CheckerboardColumnBiomeSource) {
            return true;
        }
        StructureData structureData = structure.structurify$getStructureData();
        if (structureData == null) {
            return true;
        }
        boolean biomeCheckResult = StructureBiomeCheck.checkBiomes(structureCheckData, biomeCheckData, biomeSource, randomState);
        return biomeCheckResult;
    }

    private static boolean checkFlatness(StructureCheckData structureCheckData, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState) {
        FlatnessCheckData flatnessCheckData = StructureFlatnessCheck.getFlatnessCheckData(structureCheckData);
        if (!StructureFlatnessCheck.canDoFlatnessCheck(structureCheckData)) {
            return true;
        }
        boolean flatnessCheckResult = StructureFlatnessCheck.checkFlatness(structureCheckData, flatnessCheckData, chunkGenerator, heightAccessor, randomState);
        return flatnessCheckResult;
    }

    private static boolean checkOverlap(StructureCheckData structureCheckData, StructurifyChunkGenerator chunkGenerator) {
        if (!Structurify.getConfig().preventStructureOverlap) {
            return true;
        }
        StructureData structureData = structureCheckData.getStructure().structurify$getStructureData();
        if (structureData == null) {
            return true;
        }
        GenerationStep.Decoration structureStep = structureData.getStep();
        if (structureStep == GenerationStep.Decoration.RAW_GENERATION) {
            return true;
        }
        boolean overlapCheckResult = StructureOverlapCheck.checkForOverlap(structureCheckData, chunkGenerator);
        return !overlapCheckResult;
    }

    public static long generateStructureCheckId(ResourceLocation structureId, BlockPos structureCenter) {
        long structHash = structureId.hashCode();
        structHash ^= structHash >>> 33;
        structHash *= -49064778989728563L;
        structHash ^= structHash >>> 33;
        structHash *= -4265267296055464877L;
        structHash ^= structHash >>> 33;
        return Long.rotateLeft(structHash, 23) ^ Long.rotateLeft(ChunkPos.m_151388_((BlockPos)structureCenter), 11);
    }
}

