/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.util;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.modcompat.ModChecker;
import com.faboslav.structurify.common.modcompat.ModCompat;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public final class BiomeUtil {
    public static class_6862<class_1959> C_IS_OCEAN = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)Structurify.makeNamespacedId("c:is_ocean"));
    public static class_6862<class_1959> C_IS_RIVER = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)Structurify.makeNamespacedId("c:is_river"));

    public static Set<class_5321<class_1959>> getWaterBiomes() {
        class_7225.class_7226<class_1959> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return new HashSet<class_5321<class_1959>>();
        }
        HashSet<class_5321<class_1959>> oceanBiomes = new HashSet<class_5321<class_1959>>();
        biomeRegistry.method_46733(class_6908.field_36509).ifPresent(named -> oceanBiomes.addAll(named.method_40239().map(h -> h.method_40230().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        biomeRegistry.method_46733(class_6908.field_36511).ifPresent(named -> oceanBiomes.addAll(named.method_40239().map(h -> h.method_40230().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        biomeRegistry.method_46733(C_IS_OCEAN).ifPresent(named -> oceanBiomes.addAll(named.method_40239().map(h -> h.method_40230().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        biomeRegistry.method_46733(C_IS_RIVER).ifPresent(named -> oceanBiomes.addAll(named.method_40239().map(h -> h.method_40230().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        return oceanBiomes;
    }

    public static boolean isWaterStructure(class_6885<class_1959> structureBiomes) {
        if (structureBiomes == null || structureBiomes.method_40247() == 0) {
            return false;
        }
        Set<class_5321<class_1959>> waterBiomes = BiomeUtil.getWaterBiomes();
        return structureBiomes.method_40239().map(h -> h.method_40230().orElse(null)).allMatch(k -> k != null && waterBiomes.contains(k));
    }

    public static class_6885<class_1959> getBiomes(class_2960 structureId, class_6885<class_1959> originalBiomes) {
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return originalBiomes;
        }
        class_7225.class_7226<class_1959> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return originalBiomes;
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        List<String> biomeIds = structureData.getBiomes();
        return BiomeUtil.getBiomeHolders(biomeIds, biomeRegistry);
    }

    public static class_6885<class_1959> getBlacklistedBiomes(class_2960 structureId) {
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return class_6885.method_40242(new ArrayList());
        }
        class_7225.class_7226<class_1959> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return class_6885.method_40242(new ArrayList());
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        List<String> blacklistedBiomeIds = structureData.getBiomeCheckData().getBlacklistedBiomes();
        return BiomeUtil.getBiomeHolders(blacklistedBiomeIds, biomeRegistry);
    }

    public static class_6885<class_1959> getBiomeHolders(List<String> biomeIds, class_7225.class_7226<class_1959> biomeRegistry) {
        for (ModCompat modCompat : ModChecker.BIOME_REPLACER_COMPATS) {
            try {
                List<String> replacedBiomeIds = modCompat.getReplacedBiomes(biomeIds);
                biomeIds.addAll(replacedBiomeIds);
            }
            catch (Throwable e) {
                Structurify.getLogger().error("Failed to get replaced biomes from mod compat");
                e.printStackTrace();
            }
        }
        ArrayList<Object> biomeHolders = new ArrayList<Object>();
        for (String biomeId : biomeIds) {
            if (biomeId.contains("#")) {
                class_6862 biomeTagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)Structurify.makeNamespacedId(biomeId.replace("#", "")));
                class_6885.class_6888 biomeTagHolder = biomeRegistry.method_46733(biomeTagKey).orElse(null);
                if (biomeTagHolder == null) continue;
                for (class_6880 biomeHolder : biomeTagHolder.method_40239().toList()) {
                    biomeHolders.add(biomeHolder);
                }
                continue;
            }
            class_5321 biomeResourceKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)Structurify.makeNamespacedId(biomeId.replace("#", "")));
            class_6880.class_6883 biomeHolder = biomeRegistry.method_46746(biomeResourceKey).orElse(null);
            if (biomeHolder == null) continue;
            biomeHolders.add(biomeHolder);
        }
        return class_6885.method_40242(biomeHolders);
    }
}

