/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.DebugData;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;

public final class StructurePieceSampler {
    public static List<class_3443> getStructurePieces(class_3449 structureStart) {
        List<class_3443> structurePieces = structureStart.method_14963();
        if (Structurify.getConfig().getDebugData().getSamplingMode() == DebugData.SamplingMode.MINIMAL) {
            return structurePieces;
        }
        structurePieces = StructurePieceSampler.getOnlyMainPieces(structurePieces);
        return structurePieces;
    }

    public static int[][] getStructurePieceSamples(List<class_3443> structurePieces, class_2338 structureCenter) {
        if (structurePieces.isEmpty()) {
            return new int[0][];
        }
        int[][] pieceSamples = StructurePieceSampler.getStructurePieceCorners(structurePieces);
        if (Structurify.getConfig().getDebugData().getSamplingMode() == DebugData.SamplingMode.MINIMAL) {
            return pieceSamples;
        }
        pieceSamples = StructurePieceSampler.mergeTouchingPositions(pieceSamples);
        if (Structurify.getConfig().getDebugData().getSamplingMode() == DebugData.SamplingMode.MERGED_SAMPLES) {
            return pieceSamples;
        }
        pieceSamples = StructurePieceSampler.orderStructureCornersByDistance(pieceSamples, structureCenter);
        return pieceSamples;
    }

    private static List<class_3443> getOnlyMainPieces(List<class_3443> pieces) {
        int count = pieces.size();
        ArrayList<class_3443> mainPieces = new ArrayList<class_3443>(count);
        for (int candidateIndex = 0; candidateIndex < count; ++candidateIndex) {
            class_3443 candidatePiece = pieces.get(candidateIndex);
            class_3341 candidateBox = candidatePiece.method_14935();
            if (candidateBox.method_35414() <= 2 || candidateBox.method_14663() <= 2) continue;
            boolean isInsideAnotherPiece = false;
            for (int otherIndex = 0; otherIndex < count; ++otherIndex) {
                if (candidateIndex == otherIndex || !StructurePieceSampler.containsBox(pieces.get(otherIndex).method_14935(), candidateBox)) continue;
                isInsideAnotherPiece = true;
                break;
            }
            if (isInsideAnotherPiece) continue;
            mainPieces.add(candidatePiece);
        }
        return mainPieces;
    }

    private static int[][] getStructurePieceCorners(List<class_3443> pieces) {
        int pieceCount = pieces.size();
        int[][] structureCorners = new int[pieceCount * 5][2];
        int structureCornerIndex = 0;
        for (class_3443 piece : pieces) {
            class_3341 pieceBox = piece.method_14935();
            int minX = pieceBox.method_35415();
            int minZ = pieceBox.method_35417();
            int maxX = pieceBox.method_35418();
            int maxZ = pieceBox.method_35420();
            structureCorners[structureCornerIndex++] = new int[]{minX, minZ};
            structureCorners[structureCornerIndex++] = new int[]{minX, maxZ};
            structureCorners[structureCornerIndex++] = new int[]{maxX, minZ};
            structureCorners[structureCornerIndex++] = new int[]{maxX, maxZ};
            int centerX = (minX + maxX) / 2;
            int centerZ = (minZ + maxZ) / 2;
            structureCorners[structureCornerIndex++] = new int[]{centerX, centerZ};
        }
        return structureCorners;
    }

    private static int[][] mergeTouchingPositions(int[][] inputPositions) {
        HashSet<Long> uniqueKeys = new HashSet<Long>();
        ArrayList<int[]> uniquePositions = new ArrayList<int[]>();
        for (int[] position : inputPositions) {
            long key = class_1923.method_8331((int)position[0], (int)position[1]);
            if (!uniqueKeys.add(key)) continue;
            uniquePositions.add(position);
        }
        ArrayList<int[]> mergedPositions = new ArrayList<int[]>();
        boolean[] visited = new boolean[uniquePositions.size()];
        for (int i = 0; i < uniquePositions.size(); ++i) {
            if (visited[i]) continue;
            ArrayList<int[]> group = new ArrayList<int[]>();
            ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
            queue.add(i);
            visited[i] = true;
            while (!queue.isEmpty()) {
                int currentIndex = (Integer)queue.poll();
                int[] current = (int[])uniquePositions.get(currentIndex);
                group.add(current);
                for (int j = 0; j < uniquePositions.size(); ++j) {
                    int[] candidate;
                    if (visited[j] || Math.abs((candidate = (int[])uniquePositions.get(j))[0] - current[0]) > 1 || Math.abs(candidate[1] - current[1]) > 1) continue;
                    visited[j] = true;
                    queue.add(j);
                }
            }
            int[] best = (int[])group.get(0);
            double bestDistance = Double.MAX_VALUE;
            double avgX = group.stream().mapToInt(p -> p[0]).average().orElse(0.0);
            double avgZ = group.stream().mapToInt(p -> p[1]).average().orElse(0.0);
            for (int[] pos : group) {
                double dz;
                double dx = (double)pos[0] - avgX;
                double dist = dx * dx + (dz = (double)pos[1] - avgZ) * dz;
                if (!(dist < bestDistance) && (dist != bestDistance || pos[0] >= best[0] && (pos[0] != best[0] || pos[1] >= best[1]))) continue;
                best = pos;
                bestDistance = dist;
            }
            mergedPositions.add(best);
        }
        return (int[][])mergedPositions.toArray((T[])new int[mergedPositions.size()][]);
    }

    private static int[][] orderStructureCornersByDistance(int[][] samples, class_2338 structureCenter) {
        int centerX = structureCenter.method_10263();
        int centerZ = structureCenter.method_10260();
        ArrayList sortedSamples = new ArrayList(samples.length);
        sortedSamples.addAll(Arrays.asList(samples));
        sortedSamples.sort((a, b) -> {
            int ax = a[0];
            int az = a[1];
            int bx = b[0];
            int bz = b[1];
            int distA = Math.max(Math.abs(ax - centerX), Math.abs(az - centerZ));
            int distB = Math.max(Math.abs(bx - centerX), Math.abs(bz - centerZ));
            return Integer.compare(distB, distA);
        });
        int[][] result = new int[sortedSamples.size()][2];
        for (int i = 0; i < sortedSamples.size(); ++i) {
            result[i] = (int[])sortedSamples.get(i);
        }
        return result;
    }

    private static boolean containsBox(class_3341 outer, class_3341 inner) {
        return outer.method_35415() <= inner.method_35415() && outer.method_35418() >= inner.method_35418() && outer.method_35416() <= inner.method_35416() && outer.method_35419() >= inner.method_35419() && outer.method_35417() <= inner.method_35417() && outer.method_35420() >= inner.method_35420();
    }

    private StructurePieceSampler() {
    }
}

